/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.handler;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.Callback;
import com.ning.http.client.providers.netty.DiscardEvent;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.future.StackTraceInspector;
import com.ning.http.client.providers.netty.handler.Protocol;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.PrematureChannelClosureException;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processor
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class);
    public static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Remotely closed");
    public static final IOException CHANNEL_CLOSED_EXCEPTION = new IOException("Channel closed");
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final Protocol protocol;

    public Processor(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender, Protocol protocol) {
        this.config = config;
        this.channelManager = channelManager;
        this.requestSender = requestSender;
        this.protocol = protocol;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        Channel channel = ctx.getChannel();
        Object attribute = Channels.getAttribute(channel);
        if (attribute == null) {
            LOGGER.debug("ChannelHandlerContext doesn't have any attribute");
        }
        if (attribute instanceof Callback) {
            Object message = e.getMessage();
            Callback ac = (Callback)attribute;
            if (message instanceof HttpChunk) {
                if (((HttpChunk)HttpChunk.class.cast(message)).isLast()) {
                    ac.call();
                }
            } else {
                LOGGER.info("Received unexpected message while expecting a chunk: " + message);
                ac.call();
                Channels.setDiscard(channel);
            }
        } else if (attribute instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)attribute;
            this.protocol.handle(channel, future, e.getMessage());
        } else if (attribute != DiscardEvent.INSTANCE) {
            LOGGER.trace("Closing an orphan channel {}", (Object)channel);
            Channels.silentlyCloseChannel(channel);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.requestSender.isClosed()) {
            return;
        }
        Channel channel = ctx.getChannel();
        this.channelManager.removeAll(channel);
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            LOGGER.trace("super.channelClosed", (Throwable)ex);
        }
        Object attribute = Channels.getAttribute(channel);
        LOGGER.debug("Channel Closed: {} with attribute {}", (Object)channel, attribute);
        if (attribute instanceof Callback) {
            Callback callback = (Callback)attribute;
            Channels.setAttribute(channel, callback.future());
            callback.call();
        } else if (attribute instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)attribute;
            future.touch();
            if (!this.config.getIOExceptionFilters().isEmpty() && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, CHANNEL_CLOSED_EXCEPTION, channel)) {
                return;
            }
            this.protocol.onClose(future);
            if (future.isDone()) {
                this.channelManager.closeChannel(channel);
            } else if (!this.requestSender.retry(future)) {
                this.requestSender.abort(channel, future, REMOTELY_CLOSED_EXCEPTION);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        Throwable cause = e.getCause();
        NettyResponseFuture<?> future = null;
        if (cause instanceof PrematureChannelClosureException || cause instanceof ClosedChannelException) {
            return;
        }
        LOGGER.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
        try {
            Object attribute = Channels.getAttribute(channel);
            if (attribute instanceof NettyResponseFuture) {
                future = (NettyResponseFuture<?>)attribute;
                future.attachChannel(null, false);
                future.touch();
                if (cause instanceof IOException && !this.config.getIOExceptionFilters().isEmpty()) {
                    if (!this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, CHANNEL_CLOSED_EXCEPTION, channel)) {
                        Channels.silentlyCloseChannel(channel);
                    }
                    return;
                }
                if (StackTraceInspector.abortOnReadOrWriteException(cause)) {
                    LOGGER.debug("Trying to recover from dead Channel: {}", (Object)channel);
                    return;
                }
            } else if (attribute instanceof Callback) {
                future = ((Callback)attribute).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future != null) {
            try {
                LOGGER.debug("Was unable to recover Future: {}", (Object)future);
                this.requestSender.abort(channel, future, cause);
                this.protocol.onError(future, e.getCause());
            }
            catch (Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }
        }
        this.channelManager.closeChannel(channel);
        ctx.sendUpstream((ChannelEvent)e);
    }

    static {
        REMOTELY_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        CHANNEL_CLOSED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

