/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.PartBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringPart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private final byte[] content;
    private final String value;

    public StringPart(String name, String value, Charset charset) {
        this(name, value, charset, null);
    }

    private static Charset charsetOrDefault(Charset charset) {
        return charset == null ? DEFAULT_CHARSET : charset;
    }

    public StringPart(String name, String value, Charset charset, String contentId) {
        super(name, DEFAULT_CONTENT_TYPE, StringPart.charsetOrDefault(charset), contentId, DEFAULT_TRANSFER_ENCODING);
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.content = value.getBytes(StringPart.charsetOrDefault(charset));
        this.value = value;
    }

    @Override
    protected void sendData(OutputStream out) throws IOException {
        out.write(this.content);
    }

    @Override
    protected long getDataLength() {
        return this.content.length;
    }

    public byte[] getBytes(byte[] boundary) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.write(outputStream, boundary);
        return outputStream.toByteArray();
    }

    @Override
    public long write(WritableByteChannel target, byte[] boundary) throws IOException {
        return MultipartUtils.writeBytesToChannel(target, this.getBytes(boundary));
    }

    public String getValue() {
        return this.value;
    }
}

