/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.extra;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleRequestFilter
implements RequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottleRequestFilter.class);
    private final Semaphore available;
    private final int maxWait;

    public ThrottleRequestFilter(int maxConnections) {
        this(maxConnections, Integer.MAX_VALUE);
    }

    public ThrottleRequestFilter(int maxConnections, int maxWait) {
        this.maxWait = maxWait;
        this.available = new Semaphore(maxConnections, true);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current Throttling Status {}", (Object)this.available.availablePermits());
            }
            if (!this.available.tryAcquire(this.maxWait, TimeUnit.MILLISECONDS)) {
                throw new FilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
            }
        }
        catch (InterruptedException e) {
            throw new FilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new FilterContext.FilterContextBuilder(ctx).asyncHandler(new AsyncHandlerWrapper(ctx.getAsyncHandler())).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncHandlerWrapper<T>
    implements AsyncHandler<T> {
        private final AsyncHandler<T> asyncHandler;
        private final AtomicBoolean complete = new AtomicBoolean(false);

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
        }

        private void complete() {
            if (this.complete.compareAndSet(false, true)) {
                ThrottleRequestFilter.this.available.release();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Current Throttling Status after onThrowable {}", (Object)ThrottleRequestFilter.this.available.availablePermits());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThrowable(Throwable t) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            finally {
                this.complete();
            }
        }

        @Override
        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        @Override
        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return this.asyncHandler.onStatusReceived(responseStatus);
        }

        @Override
        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T onCompleted() throws Exception {
            try {
                T t = this.asyncHandler.onCompleted();
                return t;
            }
            finally {
                this.complete();
            }
        }
    }
}

