/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.timeout;

import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.timeout.TimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.util.DateUtils;
import org.jboss.netty.util.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder, long requestTimeout) {
        super(nettyResponseFuture, provider, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    public void run(Timeout timeout) throws Exception {
        this.timeoutsHolder.cancel();
        if (this.provider.isClose() || this.nettyResponseFuture.isDone()) {
            return;
        }
        String message = "Request timed out to " + this.nettyResponseFuture.getChannelRemoteAddress() + " of " + this.requestTimeout + " ms";
        long age = DateUtils.millisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

