/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.util.HostnameChecker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class ProxyHostnameChecker
implements HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private final Object checker = this.getHostnameChecker();

    private Object getHostnameChecker() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> hostnameCheckerClass = classLoader.loadClass("sun.security.util.HostnameChecker");
            Method instanceMethod = hostnameCheckerClass.getMethod("getInstance", Byte.TYPE);
            return instanceMethod.invoke(null, (byte)1);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public void match(String hostname, X509Certificate peerCertificate) throws CertificateException {
        try {
            Class<?> hostnameCheckerClass = this.checker.getClass();
            Method checkMethod = hostnameCheckerClass.getMethod("match", String.class, X509Certificate.class);
            checkMethod.invoke(this.checker, hostname, peerCertificate);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof CertificateException) {
                throw (CertificateException)t;
            }
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean match(String hostname, Principal principal) {
        try {
            Class<?> hostnameCheckerClass = this.checker.getClass();
            Method checkMethod = hostnameCheckerClass.getMethod("match", String.class, Principal.class);
            return (Boolean)checkMethod.invoke(null, hostname, principal);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

