/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.multipart.CounterPartVisitor;
import com.ning.http.client.multipart.OutputStreamPartVisitor;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.PartVisitor;
import com.ning.http.util.StandardCharsets;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PartBase
implements Part {
    private final String name;
    private final String contentType;
    private final String charSet;
    private final String transferEncoding;
    private final String contentId;
    private String dispositionType;

    public PartBase(String name, String contentType, String charSet, String transferEncoding, String contentId) {
        this.name = name;
        this.contentType = contentType;
        this.charSet = charSet;
        this.transferEncoding = transferEncoding;
        this.contentId = contentId;
    }

    protected void visitStart(PartVisitor visitor, byte[] boundary) throws IOException {
        visitor.withBytes(EXTRA_BYTES);
        visitor.withBytes(boundary);
    }

    protected void visitDispositionHeader(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CONTENT_DISPOSITION_BYTES);
        visitor.withBytes(this.getDispositionType() != null ? this.getDispositionType().getBytes(StandardCharsets.US_ASCII) : FORM_DATA_DISPOSITION_TYPE_BYTES);
        if (this.getName() != null) {
            visitor.withBytes(NAME_BYTES);
            visitor.withByte((byte)34);
            visitor.withBytes(this.getName().getBytes(StandardCharsets.US_ASCII));
            visitor.withByte((byte)34);
        }
    }

    protected void visitContentTypeHeader(PartVisitor visitor) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TYPE_BYTES);
            visitor.withBytes(contentType.getBytes(StandardCharsets.US_ASCII));
            String charSet = this.getCharSet();
            if (charSet != null) {
                visitor.withBytes(CHARSET_BYTES);
                visitor.withBytes(charSet.getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    protected void visitTransferEncodingHeader(PartVisitor visitor) throws IOException {
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TRANSFER_ENCODING_BYTES);
            visitor.withBytes(transferEncoding.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitContentIdHeader(PartVisitor visitor) throws IOException {
        String contentId = this.getContentId();
        if (contentId != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_ID_BYTES);
            visitor.withBytes(contentId.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitEndOfHeader(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CRLF_BYTES);
    }

    protected void visitEnd(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
    }

    protected abstract long getDataLength();

    protected abstract void sendData(OutputStream var1) throws IOException;

    @Override
    public void write(OutputStream out, byte[] boundary) throws IOException {
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(out);
        this.visitStart(visitor, boundary);
        this.visitDispositionHeader(visitor);
        this.visitContentTypeHeader(visitor);
        this.visitTransferEncodingHeader(visitor);
        this.visitContentIdHeader(visitor);
        this.visitEndOfHeader(visitor);
        this.sendData(visitor.getOutputStream());
        this.visitEnd(visitor);
    }

    @Override
    public long length(byte[] boundary) {
        long dataLength = this.getDataLength();
        try {
            if (dataLength < 0L) {
                return -1L;
            }
            CounterPartVisitor visitor = new CounterPartVisitor();
            this.visitStart(visitor, boundary);
            this.visitDispositionHeader(visitor);
            this.visitContentTypeHeader(visitor);
            this.visitTransferEncodingHeader(visitor);
            this.visitContentIdHeader(visitor);
            this.visitEndOfHeader(visitor);
            this.visitEnd(visitor);
            return dataLength + visitor.getCount();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while computing length, WTF", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name=" + this.getName() + " contentType=" + this.getContentType() + " charset=" + this.getCharSet() + " tranferEncoding=" + this.getTransferEncoding() + " contentId=" + this.getContentId() + " dispositionType=" + this.getDispositionType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getDispositionType() {
        return this.dispositionType;
    }

    public void setDispositionType(String dispositionType) {
        this.dispositionType = dispositionType;
    }
}

