/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.NettyRequest;
import com.ning.http.client.providers.netty.request.NettyRequestFactory;
import com.ning.http.client.providers.netty.request.ProgressListener;
import com.ning.http.client.providers.netty.request.body.NettyConnectListener;
import com.ning.http.client.providers.netty.request.timeout.ReadTimeoutTimerTask;
import com.ning.http.client.providers.netty.request.timeout.RequestTimeoutTimerTask;
import com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    public static final String GZIP_DEFLATE = "gzip,deflate";
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final Timer nettyTimer;
    private final AtomicBoolean closed;
    private final NettyRequestFactory requestFactory;

    public NettyRequestSender(AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, ChannelManager channelManager, Timer nettyTimer, AtomicBoolean closed) {
        this.config = config;
        this.channelManager = channelManager;
        this.nettyTimer = nettyTimer;
        this.closed = closed;
        this.requestFactory = new NettyRequestFactory(config, nettyConfig);
    }

    public <T> ListenableFuture<T> sendRequest(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache) throws IOException {
        boolean useProxy;
        if (this.closed.get()) {
            throw new IOException("Closed");
        }
        UriComponents uri = request.getURI();
        if (uri.getScheme().startsWith("ws") && !this.validateWebSocketRequest(request, asyncHandler)) {
            throw new IOException("WebSocket method must be a GET");
        }
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        boolean resultOfAConnect = future != null && future.getNettyRequest() != null && future.getNettyRequest().getHttpRequest().getMethod() == HttpMethod.CONNECT;
        boolean bl = useProxy = proxyServer != null && !resultOfAConnect;
        if (useProxy && HttpUtils.useProxyConnect(uri)) {
            if (future != null && future.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, uri, proxyServer, true, true);
            }
            return this.sendRequestThroughSslProxy(request, asyncHandler, future, reclaimCache, uri, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, uri, proxyServer, useProxy, false);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, UriComponents uri, ProxyServer proxyServer, boolean useProxy, boolean forceConnect) throws IOException {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, forceConnect);
        Channel channel = this.getCachedChannel(future, uri, request.getConnectionPoolKeyStrategy(), proxyServer);
        if (Channels.isChannelValid(channel)) {
            return this.sendRequestWithCachedChannel(request, uri, proxyServer, newFuture, asyncHandler, channel);
        }
        return this.sendRequestWithNewChannel(request, uri, proxyServer, useProxy, newFuture, asyncHandler, reclaimCache);
    }

    private <T> ListenableFuture<T> sendRequestThroughSslProxy(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, UriComponents uri, ProxyServer proxyServer) throws IOException {
        NettyResponseFuture<T> newFuture = null;
        int i = 0;
        if (i < 3) {
            Channel channel = this.getCachedChannel(future, uri, request.getConnectionPoolKeyStrategy(), proxyServer);
            if (Channels.isChannelValid(channel) && newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, false);
            }
            if (Channels.isChannelValid(channel)) {
                return this.sendRequestWithCachedChannel(request, uri, proxyServer, newFuture, asyncHandler, channel);
            }
        }
        newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, uri, proxyServer, true);
        return this.sendRequestWithNewChannel(request, uri, proxyServer, true, newFuture, asyncHandler, reclaimCache);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, UriComponents uri, ProxyServer proxy, boolean forceConnect) throws IOException {
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request, uri, forceConnect, proxy);
        if (originalFuture == null) {
            return this.newNettyResponseFuture(uri, request, asyncHandler, nettyRequest, proxy);
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setRequest(request);
        return originalFuture;
    }

    private Channel getCachedChannel(NettyResponseFuture<?> future, UriComponents uri, ConnectionPoolKeyStrategy poolKeyGen, ProxyServer proxyServer) {
        if (future != null && future.reuseChannel() && Channels.isChannelValid(future.channel())) {
            return future.channel();
        }
        return this.pollAndVerifyCachedChannel(uri, proxyServer, poolKeyGen);
    }

    private <T> ListenableFuture<T> sendRequestWithCachedChannel(Request request, UriComponents uri, ProxyServer proxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, Channel channel) throws IOException {
        future.setState(NettyResponseFuture.STATE.POOLED);
        future.attachChannel(channel, false);
        LOGGER.debug("\nUsing cached Channel {}\n for request \n{}\n", (Object)channel, (Object)future.getNettyRequest().getHttpRequest());
        Channels.setAttribute(channel, future);
        try {
            this.writeRequest(future, channel);
        }
        catch (Exception ex) {
            LOGGER.debug("writeRequest failure", (Throwable)ex);
            if (ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                LOGGER.debug("SSLEngine failure", (Throwable)ex);
                future = null;
            }
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                LOGGER.warn("doConnect.writeRequest()", t);
            }
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        return future;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(Request request, UriComponents uri, ProxyServer proxy, boolean useProxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, boolean reclaimCache) throws IOException {
        boolean useSSl = HttpUtils.isSecure(uri) && !useProxy;
        ClientBootstrap bootstrap = this.channelManager.getBootstrap(request.getURI().getScheme(), useProxy, useSSl);
        boolean channelPreempted = false;
        String poolKey = null;
        if (!reclaimCache) {
            if (this.config.getMaxConnectionsPerHost() > 0) {
                poolKey = this.channelManager.getPoolKey(future);
            }
            channelPreempted = this.preemptChannel(asyncHandler, poolKey);
        }
        try {
            ChannelFuture channelFuture = this.connect(request, uri, proxy, useProxy, bootstrap);
            channelFuture.addListener(new NettyConnectListener<T>(this.config, future, this, this.channelManager, channelPreempted, poolKey));
        }
        catch (Throwable t) {
            if (channelPreempted) {
                this.channelManager.abortChannelPreemption(poolKey);
            }
            this.abort(future, t.getCause() == null ? t : t.getCause());
        }
        return future;
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(UriComponents uri, Request request, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request.getConnectionPoolKeyStrategy(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            future.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future, Channel channel) {
        try {
            if (!Channels.isChannelValid(channel)) {
                return;
            }
            NettyRequest nettyRequest = future.getNettyRequest();
            HttpRequest httpRequest = nettyRequest.getHttpRequest();
            AsyncHandler<T> handler = future.getAsyncHandler();
            if (handler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(handler, httpRequest);
            }
            if (!future.isHeadersAlreadyWrittenOnContinue()) {
                try {
                    if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                        ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRequestSent();
                    }
                    channel.write((Object)httpRequest).addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, true));
                }
                catch (Throwable cause) {
                    LOGGER.debug(cause.getMessage(), cause);
                    try {
                        channel.close();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.debug(ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
            }
            if (!future.isDontWriteBodyBecauseExpectContinue() && !httpRequest.getMethod().equals((Object)HttpMethod.CONNECT) && nettyRequest.getBody() != null) {
                nettyRequest.getBody().write(channel, future, this.config);
            }
        }
        catch (Throwable ioe) {
            try {
                channel.close();
            }
            catch (RuntimeException ex) {
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        this.scheduleTimeouts(future);
    }

    private InetSocketAddress remoteAddress(Request request, UriComponents uri, ProxyServer proxy, boolean useProxy) {
        if (request.getInetAddress() != null) {
            return new InetSocketAddress(request.getInetAddress(), AsyncHttpProviderUtils.getDefaultPort(uri));
        }
        if (!useProxy || ProxyUtils.avoidProxy(proxy, uri.getHost())) {
            return new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getDefaultPort(uri));
        }
        return new InetSocketAddress(proxy.getHost(), proxy.getPort());
    }

    private ChannelFuture connect(Request request, UriComponents uri, ProxyServer proxy, boolean useProxy, ClientBootstrap bootstrap) {
        InetSocketAddress remoteAddress = this.remoteAddress(request, uri, proxy, useProxy);
        if (request.getLocalAddress() != null) {
            return bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)new InetSocketAddress(request.getLocalAddress(), 0));
        }
        return bootstrap.connect((SocketAddress)remoteAddress);
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry entries : httpRequest.headers()) {
            h.add((String)entries.getKey(), (String)entries.getValue());
        }
        ((TransferCompletionHandler)TransferCompletionHandler.class.cast(handler)).headers(h);
    }

    private void scheduleTimeouts(NettyResponseFuture<?> nettyResponseFuture) {
        try {
            int readTimeout;
            nettyResponseFuture.touch();
            int requestTimeoutInMs = AsyncHttpProviderUtils.requestTimeout(this.config, nettyResponseFuture.getRequest());
            TimeoutsHolder timeoutsHolder = new TimeoutsHolder();
            if (requestTimeoutInMs != -1) {
                Timeout requestTimeout;
                timeoutsHolder.requestTimeout = requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs), requestTimeoutInMs);
            }
            if ((readTimeout = this.config.getReadTimeout()) != -1 && readTimeout < requestTimeoutInMs) {
                Timeout idleConnectionTimeout;
                timeoutsHolder.readTimeout = idleConnectionTimeout = this.newTimeout(new ReadTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs, readTimeout), readTimeout);
            }
            nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
        }
        catch (RejectedExecutionException ex) {
            this.abort(nettyResponseFuture, ex);
        }
    }

    public Timeout newTimeout(TimerTask task, long delay) {
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }

    public void abort(NettyResponseFuture<?> future, Throwable t) {
        Channel channel = future.channel();
        if (channel != null) {
            this.channelManager.closeChannel(channel);
        }
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
        }
        future.abort(t);
    }

    public boolean retry(NettyResponseFuture<?> future, Channel channel) {
        Object attribute;
        if (this.isClosed()) {
            return false;
        }
        if (future == null && (attribute = Channels.getAttribute(channel)) instanceof NettyResponseFuture) {
            future = (NettyResponseFuture)attribute;
        }
        if (future != null && future.canBeReplayed()) {
            future.setState(NettyResponseFuture.STATE.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest().getHttpRequest());
            if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
            }
            try {
                this.sendNextRequest(future.getRequest(), future);
                return true;
            }
            catch (IOException iox) {
                future.setState(NettyResponseFuture.STATE.CLOSED);
                future.abort(iox);
                LOGGER.error("Remotely Closed, unable to recover", (Throwable)iox);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", future);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future, IOException e, Channel channel) throws IOException {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future, efe);
            }
        }
        if (fc.replayRequest() && future.canBeReplayed()) {
            this.replayRequest(future, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request, NettyResponseFuture<T> future) throws IOException {
        this.sendRequest(request, future.getAsyncHandler(), future, true);
    }

    private boolean validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        return request.getMethod().equals(HttpMethod.GET.getName()) && asyncHandler instanceof WebSocketUpgradeHandler;
    }

    public Channel pollAndVerifyCachedChannel(UriComponents uri, ProxyServer proxy, ConnectionPoolKeyStrategy connectionPoolKeyStrategy) {
        Channel channel = this.channelManager.poll(connectionPoolKeyStrategy.getKey(uri, proxy));
        if (channel != null) {
            LOGGER.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                this.channelManager.verifyChannelPipeline(channel.getPipeline(), uri.getScheme());
            }
            catch (Exception ex) {
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return channel;
    }

    public boolean preemptChannel(AsyncHandler<?> asyncHandler, String poolKey) throws IOException {
        boolean channelPreempted = false;
        if (!this.channelManager.preemptChannel(poolKey)) {
            IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxConnections()));
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Exception e) {
                LOGGER.warn("asyncHandler.onThrowable crashed", (Throwable)e);
            }
            throw ex;
        }
        channelPreempted = true;
        return channelPreempted;
    }

    public void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) throws IOException {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        this.channelManager.drainChannel(channel, future);
        this.sendNextRequest(newRequest, future);
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

