/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.oauth;

import com.ning.http.client.oauth.ConsumerKey;
import com.ning.http.client.oauth.RequestToken;
import com.ning.http.util.UTF8UrlEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ThreadSafeHMAC {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;

    public ThreadSafeHMAC(ConsumerKey consumerAuth, RequestToken userAuth) {
        StringBuilder sb = new StringBuilder(consumerAuth.getSecret().length() + userAuth.getSecret().length() + 16);
        UTF8UrlEncoder.appendEncoded(sb, consumerAuth.getSecret());
        sb.append('&');
        UTF8UrlEncoder.appendEncoded(sb, userAuth.getSecret());
        byte[] keyBytes = sb.toString().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        try {
            this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            this.mac.init(signingKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized byte[] digest(byte[] message) {
        this.mac.reset();
        return this.mac.doFinal(message);
    }
}

