/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.handler;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Protocol {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelManager channelManager;
    protected final AsyncHttpClientConfig config;
    protected final NettyAsyncHttpProviderConfig nettyConfig;
    protected final NettyRequestSender requestSender;
    private final boolean hasResponseFilters;
    protected final boolean hasIOExceptionFilters;
    private final MaxRedirectException maxRedirectException;
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();

    public Protocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.nettyConfig = nettyConfig;
        this.requestSender = requestSender;
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
        this.hasIOExceptionFilters = !config.getIOExceptionFilters().isEmpty();
        this.maxRedirectException = new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects());
    }

    public abstract void handle(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void onError(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void onClose(NettyResponseFuture<?> var1);

    private FluentCaseInsensitiveStringsMap propagatedHeaders(Request request, Realm realm, boolean switchToGet) {
        FluentCaseInsensitiveStringsMap headers = request.getHeaders().delete("Host").delete("Content-Length").delete("Content-Type");
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.delete("Authorization").delete("Proxy-Authorization");
        }
        return headers;
    }

    protected boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm) throws Exception {
        if (AsyncHttpProviderUtils.followRedirect(this.config, request) && REDIRECT_STATUSES.contains(statusCode)) {
            if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future.getAndSetAuth(false);
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get("Location");
            Uri uri = Uri.create(future.getUri(), location);
            if (!uri.equals(future.getUri())) {
                String originalMethod = request.getMethod();
                boolean switchToGet = !originalMethod.equals("GET") && (statusCode == 303 || statusCode == 302 && !this.config.isStrict302Handling());
                RequestBuilder requestBuilder = ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? "GET" : originalMethod).setCookies(request.getCookies())).setConnectionPoolKeyStrategy(request.getConnectionPoolPartitioning())).setFollowRedirects(true).setLocalInetAddress(request.getLocalAddress())).setNameResolver(request.getNameResolver())).setProxyServer(request.getProxyServer()).setRealm(request.getRealm())).setRequestTimeout(request.getRequestTimeout())).setVirtualHost(request.getVirtualHost());
                requestBuilder.setHeaders(this.propagatedHeaders(request, realm, switchToGet));
                boolean initialConnectionKeepAlive = future.isKeepAlive();
                Object initialPartitionKey = future.getPartitionKey();
                future.setUri(uri);
                String newUrl = uri.toUrl();
                if (request.getUri().getScheme().startsWith("ws")) {
                    newUrl = newUrl.replaceFirst("http", "ws");
                }
                this.logger.debug("Redirecting to {}", (Object)newUrl);
                for (String cookieStr : responseHeaders.getAll("Set-Cookie")) {
                    Cookie c = CookieDecoder.decode(cookieStr);
                    if (c == null) continue;
                    requestBuilder.addOrReplaceCookie(c);
                }
                requestBuilder.setHeaders(this.propagatedHeaders(future.getRequest(), realm, switchToGet));
                Request nextRequest = requestBuilder.setUrl(newUrl).build();
                this.logger.debug("Sending redirect to {}", (Object)request.getUri());
                if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                    if (AsyncHttpProviderUtils.isSameHostAndProtocol(request.getUri(), nextRequest.getUri())) {
                        future.setReuseChannel(true);
                    } else {
                        this.channelManager.drainChannelAndOffer(channel, future, initialConnectionKeepAlive, initialPartitionKey);
                    }
                } else {
                    this.channelManager.closeChannel(channel);
                }
                this.requestSender.sendNextRequest(nextRequest, future);
                return true;
            }
        }
        return false;
    }

    protected boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpResponseHeaders responseHeaders) throws IOException {
        if (this.hasResponseFilters) {
            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
            for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                try {
                    if ((fc = asyncFilter.filter(fc)) != null) continue;
                    throw new NullPointerException("FilterContext is null");
                }
                catch (FilterException efe) {
                    this.requestSender.abort(channel, future, efe);
                }
            }
            future.setAsyncHandler(fc.getAsyncHandler());
            if (fc.replayRequest()) {
                this.requestSender.replayRequest(future, fc, channel);
                return true;
            }
        }
        return false;
    }

    static {
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.MOVED_PERMANENTLY.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.FOUND.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.SEE_OTHER.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.TEMPORARY_REDIRECT.getCode());
    }
}

