/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.threadpool.Threads;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.Futures;

public class FeedableBodyGenerator
implements BodyGenerator {
    public static final int UNBOUND = -1;
    public static final int DEFAULT = -2;
    private volatile HttpRequestPacket requestPacket;
    private volatile FilterChainContext context;
    private volatile HttpContent.Builder contentBuilder;
    private final EmptyBody EMPTY_BODY = new EmptyBody();
    private Feeder feeder;
    private int origMaxPendingBytes;
    private int configuredMaxPendingBytes = -2;
    private boolean asyncTransferInitiated;

    @Override
    public Body createBody() throws IOException {
        return this.EMPTY_BODY;
    }

    public synchronized void setMaxPendingBytes(int maxPendingBytes) {
        if (maxPendingBytes < -2) {
            throw new IllegalArgumentException("Invalid maxPendingBytes value: " + maxPendingBytes);
        }
        if (this.asyncTransferInitiated) {
            throw new IllegalStateException("Unable to set max pending bytes after async data transfer has been initiated.");
        }
        this.configuredMaxPendingBytes = maxPendingBytes;
    }

    public synchronized void setFeeder(Feeder feeder) {
        if (this.asyncTransferInitiated) {
            throw new IllegalStateException("Unable to set Feeder after async data transfer has been initiated.");
        }
        if (feeder == null) {
            throw new IllegalArgumentException("Feeder argument cannot be null.");
        }
        this.feeder = feeder;
    }

    synchronized void initializeAsynchronousTransfer(FilterChainContext context, HttpRequestPacket requestPacket) throws IOException {
        if (this.asyncTransferInitiated) {
            throw new IllegalStateException("Async transfer has already been initiated.");
        }
        if (this.feeder == null) {
            throw new IllegalStateException("No feeder available to perform the transfer.");
        }
        assert (context != null);
        assert (requestPacket != null);
        this.requestPacket = requestPacket;
        this.contentBuilder = HttpContent.builder((HttpHeader)requestPacket);
        Connection c = context.getConnection();
        this.origMaxPendingBytes = c.getMaxAsyncWriteQueueSize();
        if (this.configuredMaxPendingBytes != -2) {
            c.setMaxAsyncWriteQueueSize(this.configuredMaxPendingBytes);
        }
        this.context = context;
        this.asyncTransferInitiated = true;
        if (requestPacket.isSecure() && SSLUtils.getSSLEngine((Connection)context.getConnection()) == null) {
            this.flushOnSSLHandshakeComplete();
        } else {
            this.feederFlush(context.getConnection());
        }
    }

    private void feederFlush(final Connection c) {
        if (this.isServiceThread()) {
            c.getTransport().getWorkerThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    FeedableBodyGenerator.this.feederFlush0(c);
                }
            });
        } else {
            this.feederFlush0(c);
        }
    }

    private void feederFlush0(Connection c) {
        try {
            this.feeder.flush();
        }
        catch (IOException ioe) {
            c.closeWithReason(ioe);
        }
    }

    private boolean isServiceThread() {
        return Threads.isService();
    }

    private void flushOnSSLHandshakeComplete() throws IOException {
        FilterChain filterChain = this.context.getFilterChain();
        int idx = filterChain.indexOfType(SSLFilter.class);
        assert (idx != -1);
        final SSLFilter filter = (SSLFilter)filterChain.get(idx);
        final Connection c = this.context.getConnection();
        filter.addHandshakeListener(new SSLBaseFilter.HandshakeListener(){

            public void onStart(Connection connection) {
            }

            public void onFailure(Connection connection, Throwable t) {
                connection.closeWithReason(Exceptions.makeIOException((Throwable)t));
            }

            public void onComplete(Connection connection) {
                if (c.equals(connection)) {
                    filter.removeHandshakeListener((SSLBaseFilter.HandshakeListener)this);
                    FeedableBodyGenerator.this.feederFlush(c);
                }
            }
        });
        filter.handshake(this.context.getConnection(), null);
    }

    public static abstract class SimpleFeeder
    extends BaseFeeder {
        public SimpleFeeder(FeedableBodyGenerator feedableBodyGenerator) {
            super(feedableBodyGenerator);
        }
    }

    public static abstract class NonBlockingFeeder
    extends BaseFeeder {
        public NonBlockingFeeder(FeedableBodyGenerator feedableBodyGenerator) {
            super(feedableBodyGenerator);
        }

        public abstract void canFeed() throws IOException;

        public abstract boolean isDone();

        public abstract boolean isReady();

        public abstract void notifyReadyToFeed(ReadyToFeedListener var1);

        @Override
        public synchronized void flush() throws IOException {
            Connection c = this.feedableBodyGenerator.context.getConnection();
            if (this.isReady()) {
                boolean notReady = this.writeUntilFullOrDone(c);
                if (!this.isDone()) {
                    if (notReady) {
                        this.notifyReadyToFeed(new ReadyToFeedListenerImpl());
                    } else {
                        c.notifyCanWrite((WriteHandler)new WriteHandlerImpl());
                    }
                }
            } else {
                this.notifyReadyToFeed(new ReadyToFeedListenerImpl());
            }
        }

        private boolean writeUntilFullOrDone(Connection c) throws IOException {
            while (c.canWrite()) {
                if (this.isReady()) {
                    this.canFeed();
                    continue;
                }
                return true;
            }
            return false;
        }

        private final class ReadyToFeedListenerImpl
        implements ReadyToFeedListener {
            private ReadyToFeedListenerImpl() {
            }

            @Override
            public void ready() {
                try {
                    NonBlockingFeeder.this.flush();
                }
                catch (IOException e) {
                    Connection c = NonBlockingFeeder.this.feedableBodyGenerator.context.getConnection();
                    c.setMaxAsyncWriteQueueSize(NonBlockingFeeder.this.feedableBodyGenerator.origMaxPendingBytes);
                    c.closeWithReason(Exceptions.makeIOException((Throwable)e));
                }
            }
        }

        private final class WriteHandlerImpl
        implements WriteHandler {
            private final Connection c;

            private WriteHandlerImpl() {
                this.c = NonBlockingFeeder.this.feedableBodyGenerator.context.getConnection();
            }

            public void onWritePossible() throws Exception {
                NonBlockingFeeder.this.flush();
            }

            public void onError(Throwable t) {
                this.c.setMaxAsyncWriteQueueSize(NonBlockingFeeder.this.feedableBodyGenerator.origMaxPendingBytes);
                this.c.closeWithReason(Exceptions.makeIOException((Throwable)t));
            }
        }

        public static interface ReadyToFeedListener {
            public void ready();
        }
    }

    public static abstract class BaseFeeder
    implements Feeder {
        protected final FeedableBodyGenerator feedableBodyGenerator;

        protected BaseFeeder(FeedableBodyGenerator feedableBodyGenerator) {
            this.feedableBodyGenerator = feedableBodyGenerator;
        }

        @Override
        public final synchronized void feed(Buffer buffer, boolean last) throws IOException {
            if (buffer == null) {
                throw new IllegalArgumentException("Buffer argument cannot be null.");
            }
            if (!this.feedableBodyGenerator.asyncTransferInitiated) {
                throw new IllegalStateException("Asynchronous transfer has not been initiated.");
            }
            BaseFeeder.blockUntilQueueFree(this.feedableBodyGenerator.context.getConnection());
            HttpContent content = this.feedableBodyGenerator.contentBuilder.content(buffer).last(last).build();
            LastPacketCompletionHandler handler = last ? new LastPacketCompletionHandler() : null;
            this.feedableBodyGenerator.context.write((Object)content, (CompletionHandler)handler);
        }

        private static void blockUntilQueueFree(Connection c) {
            if (!c.canWrite()) {
                final FutureImpl future = Futures.createSafeFuture();
                c.notifyCanWrite(new WriteHandler(){

                    public void onWritePossible() throws Exception {
                        future.result((Object)Boolean.TRUE);
                    }

                    public void onError(Throwable t) {
                        future.failure((Throwable)Exceptions.makeIOException((Throwable)t));
                    }
                });
                BaseFeeder.block(c, (FutureImpl<Boolean>)future);
            }
        }

        private static void block(Connection c, FutureImpl<Boolean> future) {
            try {
                long writeTimeout = c.getTransport().getWriteTimeout(TimeUnit.MILLISECONDS);
                if (writeTimeout != -1L) {
                    future.get(writeTimeout, TimeUnit.MILLISECONDS);
                } else {
                    future.get();
                }
            }
            catch (ExecutionException e) {
                c.closeWithReason(Exceptions.makeIOException((Throwable)e.getCause()));
            }
            catch (Exception e) {
                c.closeWithReason(Exceptions.makeIOException((Throwable)e));
            }
        }

        private final class LastPacketCompletionHandler
        implements CompletionHandler<WriteResult> {
            private final CompletionHandler<WriteResult> delegate;
            private final Connection c;
            private final int origMaxPendingBytes;

            private LastPacketCompletionHandler() {
                this.delegate = !BaseFeeder.this.feedableBodyGenerator.requestPacket.isCommitted() ? BaseFeeder.this.feedableBodyGenerator.context.getTransportContext().getCompletionHandler() : null;
                this.c = BaseFeeder.this.feedableBodyGenerator.context.getConnection();
                this.origMaxPendingBytes = BaseFeeder.this.feedableBodyGenerator.origMaxPendingBytes;
            }

            public void cancelled() {
                this.c.setMaxAsyncWriteQueueSize(this.origMaxPendingBytes);
                if (this.delegate != null) {
                    this.delegate.cancelled();
                }
            }

            public void failed(Throwable throwable) {
                this.c.setMaxAsyncWriteQueueSize(this.origMaxPendingBytes);
                if (this.delegate != null) {
                    this.delegate.failed(throwable);
                }
            }

            public void completed(WriteResult result) {
                this.c.setMaxAsyncWriteQueueSize(this.origMaxPendingBytes);
                if (this.delegate != null) {
                    this.delegate.completed((Object)result);
                }
            }

            public void updated(WriteResult result) {
                if (this.delegate != null) {
                    this.delegate.updated((Object)result);
                }
            }
        }
    }

    public static interface Feeder {
        public void flush() throws IOException;

        public void feed(Buffer var1, boolean var2) throws IOException;
    }

    private final class EmptyBody
    implements Body {
        private EmptyBody() {
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            return 0L;
        }

        @Override
        public void close() {
            FeedableBodyGenerator.this.context.completeAndRecycle();
            FeedableBodyGenerator.this.context = null;
            FeedableBodyGenerator.this.requestPacket = null;
            FeedableBodyGenerator.this.contentBuilder = null;
        }
    }
}

