/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.handler;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.handler.ConnectionStrategy;
import com.ning.http.client.providers.netty.handler.Protocol;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.client.providers.netty.response.NettyResponseBodyPart;
import com.ning.http.client.providers.netty.response.NettyResponseHeaders;
import com.ning.http.client.providers.netty.response.NettyResponseStatus;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.client.providers.netty.util.HttpUtils;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public final class HttpProtocol
extends Protocol {
    private final ConnectionStrategy connectionStrategy;

    public HttpProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, NettyRequestSender requestSender) {
        super(channelManager, config, nettyConfig, requestSender);
        this.connectionStrategy = nettyConfig.getConnectionStrategy();
    }

    private Realm.RealmBuilder newRealmBuilder(Realm realm) {
        return realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
    }

    private Realm kerberosChallenge(Channel channel, List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future, boolean proxyInd) throws NTLMEngineException {
        Uri uri = request.getUri();
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        String server = proxyServer == null ? host : proxyServer.getHost();
        try {
            String challengeHeader = SpnegoEngine.INSTANCE.generateToken(server);
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            return this.newRealmBuilder(realm).setUri(uri).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (Throwable throwable) {
            String ntlmAuthenticate = HttpUtils.getNTLM(proxyAuth);
            if (ntlmAuthenticate != null) {
                return this.ntlmChallenge(ntlmAuthenticate, request, proxyServer, headers, realm, future, proxyInd);
            }
            this.requestSender.abort(channel, future, throwable);
            return null;
        }
    }

    private String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? "Proxy-Authorization" : "Authorization";
    }

    private void addNTLMAuthorizationHeader(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
        headers.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private Realm ntlmChallenge(String wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future, boolean proxyInd) throws NTLMEngineException {
        boolean useRealm = proxyServer == null && realm != null;
        String ntlmDomain = useRealm ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
        String ntlmHost = useRealm ? realm.getNtlmHost() : proxyServer.getHost();
        String principal = useRealm ? realm.getPrincipal() : proxyServer.getPrincipal();
        String password = useRealm ? realm.getPassword() : proxyServer.getPassword();
        Uri uri = request.getUri();
        if (wwwAuth.equals("NTLM")) {
            String challengeHeader = NTLMEngine.INSTANCE.generateType1Msg();
            this.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
            future.getAndSetAuth(false);
            return this.newRealmBuilder(realm).setScheme(realm.getAuthScheme()).setUri(uri).setMethodName(request.getMethod()).build();
        }
        this.addType3NTLMAuthorizationHeader(wwwAuth, headers, principal, password, ntlmDomain, ntlmHost, proxyInd);
        Realm.AuthScheme authScheme = realm != null ? realm.getAuthScheme() : Realm.AuthScheme.NTLM;
        return this.newRealmBuilder(realm).setScheme(authScheme).setUri(uri).setMethodName(request.getMethod()).build();
    }

    private Realm ntlmProxyChallenge(String wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future, boolean proxyInd) throws NTLMEngineException {
        future.getAndSetAuth(false);
        headers.remove("Proxy-Authorization");
        this.addType3NTLMAuthorizationHeader(wwwAuth, headers, proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getNtlmDomain(), proxyServer.getHost(), proxyInd);
        return this.newRealmBuilder(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
    }

    private void addType3NTLMAuthorizationHeader(String auth, FluentCaseInsensitiveStringsMap headers, String username, String password, String domain, String workstation, boolean proxyInd) throws NTLMEngineException {
        headers.remove(this.authorizationHeaderName(proxyInd));
        if (MiscUtils.isNonEmpty(auth) && auth.startsWith("NTLM ")) {
            String serverChallenge = auth.substring("NTLM ".length()).trim();
            String challengeHeader = NTLMEngine.INSTANCE.generateType3Msg(username, password, domain, workstation, serverChallenge);
            this.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) throws IOException {
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.channelManager.drainChannelAndOffer(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, keepAlive, this.channelManager.getPartitionId(future));
        }
        this.markAsDone(future, channel);
    }

    private boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, NettyResponseBodyPart bodyPart) throws Exception {
        boolean interrupt;
        boolean bl = interrupt = handler.onBodyPartReceived(bodyPart) != AsyncHandler.STATE.CONTINUE;
        if (bodyPart.isUnderlyingConnectionToBeClosed()) {
            future.setKeepAlive(false);
        }
        return interrupt;
    }

    private void markAsDone(NettyResponseFuture<?> future, Channel channel) {
        try {
            future.done();
        }
        catch (Throwable t) {
            this.logger.debug(t.getMessage(), t);
        }
        if (!future.isKeepAlive() || !channel.isConnected()) {
            this.channelManager.closeChannel(channel);
        }
    }

    private boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) throws Exception {
        List wwwAuthHeaders;
        if (statusCode == HttpResponseStatus.UNAUTHORIZED.getCode() && realm != null && !future.getAndSetAuth(true) && !(wwwAuthHeaders = response.headers().getAll("WWW-Authenticate")).isEmpty()) {
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            boolean negociate = wwwAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = HttpUtils.getNTLM(wwwAuthHeaders);
            if (!wwwAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmChallenge(ntlmAuthenticate, request, proxyServer, request.getHeaders(), realm, future, false);
            } else if (negociate) {
                newRealm = this.kerberosChallenge(channel, wwwAuthHeaders, request, proxyServer, request.getHeaders(), realm, future, false);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader((String)wwwAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders()).setRealm(newRealm)).build();
            this.logger.debug("Sending authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                future.setReuseChannel(true);
            } else {
                this.channelManager.closeChannel(channel);
            }
            this.requestSender.sendNextRequest(nextRequest, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling100(Channel channel, NettyResponseFuture<?> future, int statusCode) {
        if (statusCode == HttpResponseStatus.CONTINUE.getCode()) {
            future.setHeadersAlreadyWrittenOnContinue(true);
            future.setDontWriteBodyBecauseExpectContinue(false);
            this.requestSender.writeRequest(future, channel);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling407(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) throws Exception {
        List proxyAuthHeaders;
        if (statusCode == HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.getCode() && realm != null && !future.getAndSetAuth(true) && !(proxyAuthHeaders = response.headers().getAll("Proxy-Authenticate")).isEmpty()) {
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            FluentCaseInsensitiveStringsMap requestHeaders = request.getHeaders();
            boolean negociate = proxyAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = HttpUtils.getNTLM(proxyAuthHeaders);
            if (!proxyAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmProxyChallenge(ntlmAuthenticate, request, proxyServer, requestHeaders, realm, future, true);
            } else if (negociate) {
                newRealm = this.kerberosChallenge(channel, proxyAuthHeaders, request, proxyServer, requestHeaders, realm, future, true);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(request.getUri()).setOmitQuery(true).setMethodName(HttpMethod.CONNECT.getName()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader((String)proxyAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders()).setRealm(newRealm)).build();
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                future.setConnectAllowed(true);
                future.setReuseChannel(true);
            } else {
                this.channelManager.closeChannel(channel);
            }
            this.requestSender.sendNextRequest(nextRequest, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, int statusCode, HttpRequest httpRequest) throws IOException {
        if (statusCode == HttpResponseStatus.OK.getCode() && httpRequest.getMethod() == HttpMethod.CONNECT) {
            if (future.isKeepAlive()) {
                future.attachChannel(channel, true);
            }
            try {
                Uri requestUri = request.getUri();
                String scheme = requestUri.getScheme();
                String host = requestUri.getHost();
                int port = AsyncHttpProviderUtils.getDefaultPort(requestUri);
                this.logger.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)scheme);
                this.channelManager.upgradeProtocol(channel.getPipeline(), scheme, host, port);
            }
            catch (Throwable ex) {
                this.requestSender.abort(channel, future, ex);
            }
            future.setReuseChannel(true);
            future.setConnectAllowed(false);
            this.requestSender.sendNextRequest(new RequestBuilder(future.getRequest()).build(), future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status) throws IOException, Exception {
        if (!future.getAndSetStatusReceived(true) && handler.onStatusReceived(status) != AsyncHandler.STATE.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseHeaders responseHeaders) throws IOException, Exception {
        if (!response.headers().isEmpty() && handler.onHeadersReceived(responseHeaders) != AsyncHandler.STATE.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingBody(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler) throws Exception {
        if (!response.isChunked()) {
            if (response.getContent().readableBytes() > 0) {
                this.updateBodyAndInterrupt(future, handler, new NettyResponseBodyPart(response, null, true));
            }
            this.finishUpdate(future, channel, false);
            return true;
        }
        return false;
    }

    private boolean handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setHttpHeaders(response.headers());
        future.setKeepAlive(this.connectionStrategy.keepAlive(httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), this.config, response);
        int statusCode = response.getStatus().getCode();
        Request request = future.getRequest();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        NettyResponseHeaders responseHeaders = new NettyResponseHeaders(response.headers());
        return this.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders) || this.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling407(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling100(channel, future, statusCode) || this.exitAfterHandlingRedirect(channel, future, response, request, statusCode) || this.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, httpRequest) || this.exitAfterHandlingStatus(channel, future, response, handler, status) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders) || this.exitAfterHandlingBody(channel, future, response, handler);
    }

    private void handleChunk(HttpChunk chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        boolean last = chunk.isLast();
        if (last || this.updateBodyAndInterrupt(future, handler, new NettyResponseBodyPart(null, chunk, last))) {
            HttpChunkTrailer chunkTrailer;
            if (chunk instanceof HttpChunkTrailer && !(chunkTrailer = (HttpChunkTrailer)chunk).trailingHeaders().isEmpty()) {
                NettyResponseHeaders responseHeaders = new NettyResponseHeaders(future.getHttpHeaders(), chunkTrailer.trailingHeaders());
                handler.onHeadersReceived(responseHeaders);
            }
            this.finishUpdate(future, channel, !chunk.isLast());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        future.touch();
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            if (e instanceof HttpResponse) {
                if (this.handleHttpResponse((HttpResponse)e, channel, future, handler)) {
                    return;
                }
            } else if (e instanceof HttpChunk) {
                this.handleChunk((HttpChunk)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            try {
                this.requestSender.abort(channel, future, t);
            }
            catch (Exception abortException) {
                this.logger.debug("Abort failed", (Throwable)abortException);
            }
            finally {
                this.finishUpdate(future, channel, false);
            }
            throw t;
        }
    }

    @Override
    public void onError(NettyResponseFuture<?> future, Throwable e) {
    }

    @Override
    public void onClose(NettyResponseFuture<?> future) {
    }
}

