/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.Param;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StringUtils;
import com.ning.http.util.UTF8UrlDecoder;
import java.util.List;

public enum QueryComputer {
    URL_ENCODING_ENABLED_QUERY_COMPUTER{

        private final void encodeAndAppendQueryParams(StringBuilder sb, List<Param> queryParams) {
            for (Param param : queryParams) {
                AsyncHttpProviderUtils.encodeAndAppendParam(sb, param.getName(), param.getValue());
            }
        }

        private final void encodeAndAppendQuery(StringBuilder sb, String query) {
            for (String queryParamString : query.split("&")) {
                CharSequence decodedName;
                int pos = queryParamString.indexOf(61);
                if (pos <= 0) {
                    decodedName = UTF8UrlDecoder.decode(queryParamString);
                    AsyncHttpProviderUtils.encodeAndAppendParam(sb, decodedName, null);
                    continue;
                }
                decodedName = UTF8UrlDecoder.decode(queryParamString, 0, pos);
                int valueStart = pos + 1;
                CharSequence decodedValue = UTF8UrlDecoder.decode(queryParamString, valueStart, queryParamString.length() - valueStart);
                AsyncHttpProviderUtils.encodeAndAppendParam(sb, decodedName, decodedValue);
            }
        }

        @Override
        protected final String withQueryWithParams(String query, List<Param> queryParams) {
            StringBuilder sb = StringUtils.stringBuilder();
            this.encodeAndAppendQuery(sb, query);
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withQueryWithoutParams(String query) {
            StringBuilder sb = StringUtils.stringBuilder();
            this.encodeAndAppendQuery(sb, query);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withoutQueryWithParams(List<Param> queryParams) {
            StringBuilder sb = StringUtils.stringBuilder();
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }
    ,
    URL_ENCODING_DISABLED_QUERY_COMPUTER{

        private final void appendRawQueryParam(StringBuilder sb, String name, String value) {
            sb.append(name);
            if (value != null) {
                sb.append('=').append(value);
            }
            sb.append('&');
        }

        private final void appendRawQueryParams(StringBuilder sb, List<Param> queryParams) {
            for (Param param : queryParams) {
                this.appendRawQueryParam(sb, param.getName(), param.getValue());
            }
        }

        @Override
        protected final String withQueryWithParams(String query, List<Param> queryParams) {
            StringBuilder sb = StringUtils.stringBuilder();
            sb.append(query);
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected final String withQueryWithoutParams(String query) {
            return query;
        }

        @Override
        protected final String withoutQueryWithParams(List<Param> queryParams) {
            StringBuilder sb = StringUtils.stringBuilder();
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    };


    public static QueryComputer queryComputer(boolean disableUrlEncoding) {
        return disableUrlEncoding ? URL_ENCODING_DISABLED_QUERY_COMPUTER : URL_ENCODING_ENABLED_QUERY_COMPUTER;
    }

    protected abstract String withQueryWithParams(String var1, List<Param> var2);

    protected abstract String withQueryWithoutParams(String var1);

    protected abstract String withoutQueryWithParams(List<Param> var1);

    private final String withQuery(String query, List<Param> queryParams) {
        return MiscUtils.isNonEmpty(queryParams) ? this.withQueryWithParams(query, queryParams) : this.withQueryWithoutParams(query);
    }

    private final String withoutQuery(List<Param> queryParams) {
        return MiscUtils.isNonEmpty(queryParams) ? this.withoutQueryWithParams(queryParams) : null;
    }

    public final String computeFullQueryString(String query, List<Param> queryParams) {
        return MiscUtils.isNonEmpty(query) ? this.withQuery(query, queryParams) : this.withoutQuery(queryParams);
    }
}

