/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import java.io.IOException;

public class LZFEncoder {
    private LZFEncoder() {
    }

    public static byte[] encode(byte[] data) throws IOException {
        return LZFEncoder.encode(data, data.length);
    }

    public static byte[] encode(byte[] data, int length) throws IOException {
        int left = length;
        ChunkEncoder enc = new ChunkEncoder(left);
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, 0, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        int inputOffset = chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, inputOffset, chunkLen);
            inputOffset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }
}

