/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import java.io.IOException;
import java.io.InputStream;

public class LZFDecoder {
    private static final byte BYTE_NULL = 0;
    private static final int HEADER_BYTES = 5;

    private LZFDecoder() {
    }

    public static byte[] decode(byte[] sourceBuffer) throws IOException {
        byte[] result = new byte[LZFDecoder.calculateUncompressedSize(sourceBuffer)];
        LZFDecoder.decode(sourceBuffer, result);
        return result;
    }

    public static int decode(byte[] sourceBuffer, byte[] targetBuffer) throws IOException {
        int len;
        byte[] result = targetBuffer;
        int outPtr = 0;
        for (int inPtr = 0; inPtr < sourceBuffer.length - 1; inPtr += len) {
            inPtr += 2;
            byte type = sourceBuffer[inPtr++];
            len = LZFDecoder.uint16(sourceBuffer, inPtr);
            inPtr += 2;
            if (type == 0) {
                System.arraycopy(sourceBuffer, inPtr, result, outPtr, len);
                outPtr += len;
                continue;
            }
            int uncompLen = LZFDecoder.uint16(sourceBuffer, inPtr);
            LZFDecoder.decompressChunk(sourceBuffer, inPtr += 2, result, outPtr, outPtr + uncompLen);
            outPtr += uncompLen;
        }
        return outPtr;
    }

    private static int calculateUncompressedSize(byte[] data) throws IOException {
        int uncompressedSize = 0;
        int ptr = 0;
        int blockNr = 0;
        while (ptr < data.length) {
            if (ptr == data.length + 1 && data[ptr] == 0) {
                ++ptr;
                break;
            }
            try {
                if (data[ptr] != 90 || data[ptr + 1] != 86) {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): did not start with 'ZV' signature bytes");
                }
                byte type = data[ptr + 2];
                int blockLen = LZFDecoder.uint16(data, ptr + 3);
                if (type == 0) {
                    ptr += 5;
                    uncompressedSize += blockLen;
                } else if (type == 1) {
                    uncompressedSize += LZFDecoder.uint16(data, ptr + 5);
                    ptr += 7;
                } else {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): unrecognized block type " + (type & 0xFF));
                }
                ptr += blockLen;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): truncated block header");
            }
            ++blockNr;
        }
        if (ptr != data.length) {
            throw new IOException("Corrupt input data: block #" + blockNr + " extends " + (data.length - ptr) + " beyond end of input");
        }
        return uncompressedSize;
    }

    public static int decompressChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        int bytesInOutput;
        int headerLength = is.read(inputBuffer, 0, 5);
        if (headerLength != 5) {
            return -1;
        }
        int inPtr = 0;
        if (inputBuffer[inPtr] != 90 || inputBuffer[inPtr + 1] != 86) {
            throw new IOException("Corrupt input data, block did not start with 'ZV' signature bytes");
        }
        inPtr += 2;
        byte type = inputBuffer[inPtr++];
        int compLen = LZFDecoder.uint16(inputBuffer, inPtr);
        inPtr += 2;
        if (type == 0) {
            LZFDecoder.readFully(is, false, outputBuffer, 0, compLen);
            bytesInOutput = compLen;
        } else {
            LZFDecoder.readFully(is, true, inputBuffer, 0, 2 + compLen);
            int uncompLen = LZFDecoder.uint16(inputBuffer, 0);
            LZFDecoder.decompressChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
            bytesInOutput = uncompLen;
        }
        return bytesInOutput;
    }

    public static void decompressChunk(byte[] in, int inPos, byte[] out, int outPos, int outEnd) throws IOException {
        do {
            int ctrl;
            if ((ctrl = in[inPos++] & 0xFF) < 32) {
                ctrl += inPos;
                do {
                    out[outPos++] = in[inPos];
                } while (inPos++ < ctrl);
                continue;
            }
            int len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len == 7) {
                len += in[inPos++] & 0xFF;
            }
            out[outPos] = out[outPos++ + (ctrl -= in[inPos++] & 0xFF)];
            out[outPos] = out[outPos++ + ctrl];
            int end = (len += outPos + 2) - 3;
            while (outPos < end) {
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
            }
            if (outPos >= len) continue;
            out[outPos] = out[outPos++ + ctrl];
            if (outPos >= len) continue;
            out[outPos] = out[outPos++ + ctrl];
            if (outPos >= len) continue;
            out[outPos] = out[outPos++ + ctrl];
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new IOException("Corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos);
        }
    }

    private static final int uint16(byte[] data, int ptr) {
        return ((data[ptr] & 0xFF) << 8) + (data[ptr + 1] & 0xFF);
    }

    private static final void readFully(InputStream is, boolean compressed, byte[] outputBuffer, int offset, int len) throws IOException {
        int count;
        for (int left = len; left > 0; left -= count) {
            count = is.read(outputBuffer, offset, left);
            if (count < 0) {
                throw new IOException("EOF in " + len + " byte (" + (compressed ? "" : "un") + "compressed) block: could only read " + (len - left) + " bytes");
            }
            offset += count;
        }
    }
}

