/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import java.io.IOException;
import java.io.InputStream;

public abstract class ChunkDecoder {
    protected static final byte BYTE_NULL = 0;
    protected static final int HEADER_BYTES = 5;

    public final byte[] decode(byte[] inputBuffer) throws IOException {
        byte[] result = new byte[ChunkDecoder.calculateUncompressedSize(inputBuffer, 0, inputBuffer.length)];
        this.decode(inputBuffer, 0, inputBuffer.length, result);
        return result;
    }

    public final byte[] decode(byte[] inputBuffer, int inputPtr, int inputLen) throws IOException {
        byte[] result = new byte[ChunkDecoder.calculateUncompressedSize(inputBuffer, inputPtr, inputLen)];
        this.decode(inputBuffer, inputPtr, inputLen, result);
        return result;
    }

    public final int decode(byte[] inputBuffer, byte[] targetBuffer) throws IOException {
        return this.decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public int decode(byte[] sourceBuffer, int inPtr, int inLength, byte[] targetBuffer) throws IOException {
        int outPtr = 0;
        int blockNr = 0;
        int end = inPtr + inLength - 1;
        while (inPtr < end) {
            if (sourceBuffer[inPtr] != 90 || sourceBuffer[inPtr + 1] != 86) {
                throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + inPtr + "): did not start with 'ZV' signature bytes");
            }
            inPtr += 2;
            byte type = sourceBuffer[inPtr++];
            int len = ChunkDecoder.uint16(sourceBuffer, inPtr);
            inPtr += 2;
            if (type == 0) {
                if (outPtr + len > targetBuffer.length) {
                    this._reportArrayOverflow(targetBuffer, outPtr, len);
                }
                System.arraycopy(sourceBuffer, inPtr, targetBuffer, outPtr, len);
                outPtr += len;
            } else {
                int uncompLen = ChunkDecoder.uint16(sourceBuffer, inPtr);
                if (outPtr + uncompLen > targetBuffer.length) {
                    this._reportArrayOverflow(targetBuffer, outPtr, uncompLen);
                }
                this.decodeChunk(sourceBuffer, inPtr += 2, targetBuffer, outPtr, outPtr + uncompLen);
                outPtr += uncompLen;
            }
            inPtr += len;
            ++blockNr;
        }
        return outPtr;
    }

    public abstract int decodeChunk(InputStream var1, byte[] var2, byte[] var3) throws IOException;

    public abstract void decodeChunk(byte[] var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    public static int calculateUncompressedSize(byte[] data, int ptr, int length) throws IOException {
        int uncompressedSize = 0;
        int blockNr = 0;
        int end = ptr + length;
        while (ptr < end) {
            if (ptr == data.length + 1 && data[ptr] == 0) {
                ++ptr;
                break;
            }
            try {
                if (data[ptr] != 90 || data[ptr + 1] != 86) {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): did not start with 'ZV' signature bytes");
                }
                byte type = data[ptr + 2];
                int blockLen = ChunkDecoder.uint16(data, ptr + 3);
                if (type == 0) {
                    ptr += 5;
                    uncompressedSize += blockLen;
                } else if (type == 1) {
                    uncompressedSize += ChunkDecoder.uint16(data, ptr + 5);
                    ptr += 7;
                } else {
                    throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): unrecognized block type " + (type & 0xFF));
                }
                ptr += blockLen;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): truncated block header");
            }
            ++blockNr;
        }
        if (ptr != end) {
            throw new IOException("Corrupt input data: block #" + blockNr + " extends " + (data.length - ptr) + " beyond end of input");
        }
        return uncompressedSize;
    }

    protected static final int uint16(byte[] data, int ptr) {
        return ((data[ptr] & 0xFF) << 8) + (data[ptr + 1] & 0xFF);
    }

    protected static final int readHeader(InputStream is, byte[] inputBuffer) throws IOException {
        int needed = 5;
        int count = is.read(inputBuffer, 0, needed);
        if (count == needed) {
            return count;
        }
        if (count <= 0) {
            return 0;
        }
        int offset = count;
        needed -= count;
        while ((count = is.read(inputBuffer, offset, needed)) > 0) {
            offset += count;
            if ((needed -= count) > 0) continue;
        }
        return offset;
    }

    protected static final void readFully(InputStream is, boolean compressed, byte[] outputBuffer, int offset, int len) throws IOException {
        int count;
        for (int left = len; left > 0; left -= count) {
            count = is.read(outputBuffer, offset, left);
            if (count < 0) {
                throw new IOException("EOF in " + len + " byte (" + (compressed ? "" : "un") + "compressed) block: could only read " + (len - left) + " bytes");
            }
            offset += count;
        }
    }

    protected void _reportArrayOverflow(byte[] targetBuffer, int outPtr, int dataLen) throws IOException {
        throw new IOException("Target buffer too small (" + targetBuffer.length + "): can not copy/uncompress " + dataLen + " bytes to offset " + outPtr);
    }
}

