/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.util.ChunkEncoderFactory;

public class LZFEncoder {
    public static final int MAX_CHUNK_RESULT_SIZE = 133191;

    private LZFEncoder() {
    }

    public static int estimateMaxWorkspaceSize(int inputSize) {
        if (inputSize <= 65535) {
            return 7 + inputSize + (inputSize >> 5) + (inputSize >> 6);
        }
        if ((inputSize -= 65535) <= 65535) {
            return 133191 + inputSize + 7;
        }
        int chunkCount = 1 + (inputSize + 65534) / 65535;
        return 133191 + chunkCount * 65542;
    }

    public static byte[] encode(byte[] data) {
        return LZFEncoder.encode(data, 0, data.length);
    }

    public static byte[] safeEncode(byte[] data) {
        return LZFEncoder.safeEncode(data, 0, data.length);
    }

    @Deprecated
    public static byte[] encode(byte[] data, int length) {
        return LZFEncoder.encode(data, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(byte[] data, int offset, int length) {
        ChunkEncoder enc = ChunkEncoderFactory.optimalInstance(length);
        try {
            byte[] byArray = LZFEncoder.encode(enc, data, offset, length);
            return byArray;
        }
        finally {
            enc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] safeEncode(byte[] data, int offset, int length) {
        ChunkEncoder enc = ChunkEncoderFactory.safeInstance(length);
        try {
            byte[] byArray = LZFEncoder.encode(enc, data, offset, length);
            return byArray;
        }
        finally {
            enc.close();
        }
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data, int length) {
        return LZFEncoder.encode(enc, data, 0, length);
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data, int offset, int length) {
        int left = length;
        int chunkLen = Math.min(65535, left);
        LZFChunk first = enc.encodeChunk(data, offset, chunkLen);
        if ((left -= chunkLen) < 1) {
            return first.getData();
        }
        int resultBytes = first.length();
        offset += chunkLen;
        LZFChunk last = first;
        do {
            chunkLen = Math.min(left, 65535);
            LZFChunk chunk = enc.encodeChunk(data, offset, chunkLen);
            offset += chunkLen;
            resultBytes += chunk.length();
            last.setNext(chunk);
            last = chunk;
        } while ((left -= chunkLen) > 0);
        byte[] result = new byte[resultBytes];
        int ptr = 0;
        while (first != null) {
            ptr = first.copyTo(result, ptr);
            first = first.next();
        }
        return result;
    }

    public static int appendEncoded(byte[] input, int inputPtr, int inputLength, byte[] outputBuffer, int outputPtr) {
        return LZFEncoder.appendEncoded(ChunkEncoderFactory.optimalNonAllocatingInstance(inputLength), input, inputPtr, inputLength, outputBuffer, outputPtr);
    }

    public static int safeAppendEncoded(byte[] input, int inputPtr, int inputLength, byte[] outputBuffer, int outputPtr) {
        return LZFEncoder.appendEncoded(ChunkEncoderFactory.safeNonAllocatingInstance(inputLength), input, inputPtr, inputLength, outputBuffer, outputPtr);
    }

    public static int appendEncoded(ChunkEncoder enc, byte[] input, int inputPtr, int inputLength, byte[] outputBuffer, int outputPtr) {
        int left = inputLength;
        int chunkLen = Math.min(65535, left);
        outputPtr = enc.appendEncodedChunk(input, inputPtr, chunkLen, outputBuffer, outputPtr);
        if ((left -= chunkLen) < 1) {
            return outputPtr;
        }
        inputPtr += chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            outputPtr = enc.appendEncodedChunk(input, inputPtr, chunkLen, outputBuffer, outputPtr);
            inputPtr += chunkLen;
        } while ((left -= chunkLen) > 0);
        return outputPtr;
    }
}

