/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LZFFileOutputStream
extends FileOutputStream {
    private static final int OUTPUT_BUFFER_SIZE = 65535;
    private final ChunkEncoder _encoder;
    private final BufferRecycler _recycler;
    protected byte[] _outputBuffer;
    protected int _position = 0;
    protected boolean _cfgFinishBlockOnFlush = true;
    protected boolean _outputStreamClosed;
    private final Wrapper _wrapper;

    public LZFFileOutputStream(File file) throws FileNotFoundException {
        this(ChunkEncoderFactory.optimalInstance(65535), file);
    }

    public LZFFileOutputStream(File file, boolean append) throws FileNotFoundException {
        this(ChunkEncoderFactory.optimalInstance(65535), file, append);
    }

    public LZFFileOutputStream(FileDescriptor fdObj) {
        this(ChunkEncoderFactory.optimalInstance(65535), fdObj);
    }

    public LZFFileOutputStream(String name) throws FileNotFoundException {
        this(ChunkEncoderFactory.optimalInstance(65535), name);
    }

    public LZFFileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(ChunkEncoderFactory.optimalInstance(65535), name, append);
    }

    public LZFFileOutputStream(ChunkEncoder encoder, File file) throws FileNotFoundException {
        super(file);
        this._encoder = encoder;
        this._recycler = BufferRecycler.instance();
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileOutputStream(ChunkEncoder encoder, File file, boolean append) throws FileNotFoundException {
        super(file, append);
        this._encoder = encoder;
        this._recycler = BufferRecycler.instance();
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileOutputStream(ChunkEncoder encoder, FileDescriptor fdObj) {
        super(fdObj);
        this._encoder = encoder;
        this._recycler = BufferRecycler.instance();
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileOutputStream(ChunkEncoder encoder, String name) throws FileNotFoundException {
        super(name);
        this._encoder = encoder;
        this._recycler = BufferRecycler.instance();
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileOutputStream(ChunkEncoder encoder, String name, boolean append) throws FileNotFoundException {
        super(name, append);
        this._encoder = encoder;
        this._recycler = BufferRecycler.instance();
        this._outputBuffer = this._recycler.allocOutputBuffer(65535);
        this._wrapper = new Wrapper();
    }

    public LZFFileOutputStream setFinishBlockOnFlush(boolean b) {
        this._cfgFinishBlockOnFlush = b;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (!this._outputStreamClosed) {
            if (this._position > 0) {
                this.writeCompressedBlock();
            }
            super.flush();
            this._encoder.close();
            byte[] buf = this._outputBuffer;
            if (buf != null) {
                this._outputBuffer = null;
                this._recycler.releaseOutputBuffer(buf);
            }
            this._outputStreamClosed = true;
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        if (this._cfgFinishBlockOnFlush && this._position > 0) {
            this.writeCompressedBlock();
        }
        super.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        int BUFFER_LEN = this._outputBuffer.length;
        int free = BUFFER_LEN - this._position;
        if (free >= length) {
            System.arraycopy(buffer, offset, this._outputBuffer, this._position, length);
            this._position += length;
            return;
        }
        System.arraycopy(buffer, offset, this._outputBuffer, this._position, free);
        offset += free;
        length -= free;
        this._position += free;
        this.writeCompressedBlock();
        while (length >= BUFFER_LEN) {
            this._encoder.encodeAndWriteChunk(buffer, offset, BUFFER_LEN, this._wrapper);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(buffer, offset, this._outputBuffer, 0, length);
        }
        this._position = length;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkNotClosed();
        if (this._position >= this._outputBuffer.length) {
            this.writeCompressedBlock();
        }
        this._outputBuffer[this._position++] = (byte)b;
    }

    public boolean getFinishBlockOnFlush() {
        return this._cfgFinishBlockOnFlush;
    }

    public LZFFileOutputStream finishBlock() throws IOException {
        this.checkNotClosed();
        if (this._position > 0) {
            this.writeCompressedBlock();
        }
        return this;
    }

    protected void writeCompressedBlock() throws IOException {
        int chunkLen;
        int left = this._position;
        this._position = 0;
        int offset = 0;
        do {
            chunkLen = Math.min(65535, left);
            this._encoder.encodeAndWriteChunk(this._outputBuffer, offset, chunkLen, this._wrapper);
            offset += chunkLen;
        } while ((left -= chunkLen) > 0);
    }

    protected void rawWrite(byte[] buffer, int offset, int length) throws IOException {
        super.write(buffer, offset, length);
    }

    protected void checkNotClosed() throws IOException {
        if (this._outputStreamClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }

    private final class Wrapper
    extends OutputStream {
        private Wrapper() {
        }

        @Override
        public void write(int arg0) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            LZFFileOutputStream.this.rawWrite(buffer, offset, length);
        }
    }
}

