/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.bind;

import com.ninja_squad.dbsetup.bind.Binder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public final class Binders {
    private static final Binder DEFAULT_BINDER = new DefaultBinder();
    private static final Binder DATE_BINDER = new DateBinder();
    private static final Binder TIMESTAMP_BINDER = new TimestampBinder();
    private static final Binder DECIMAL_BINDER = new DecimalBinder();
    private static final Binder INTEGER_BINDER = new IntegerBinder();
    private static final Binder TIME_BINDER = new TimeBinder();
    private static final Binder STRING_BINDER = new StringBinder();

    private Binders() {
    }

    public static Binder defaultBinder() {
        return DEFAULT_BINDER;
    }

    public static Binder stringBinder() {
        return STRING_BINDER;
    }

    public static Binder dateBinder() {
        return DATE_BINDER;
    }

    public static Binder timestampBinder() {
        return TIMESTAMP_BINDER;
    }

    public static Binder timeBinder() {
        return TIME_BINDER;
    }

    public static Binder decimalBinder() {
        return DECIMAL_BINDER;
    }

    public static Binder integerBinder() {
        return INTEGER_BINDER;
    }

    private static final class DefaultBinder
    implements Binder {
        private DefaultBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            Object boundValue = value instanceof Enum ? ((Enum)value).name() : (value instanceof Date ? new Timestamp(((Date)value).getTime()) : (value instanceof Calendar ? new Timestamp(((Calendar)value).getTime().getTime()) : value));
            stmt.setObject(param, boundValue);
        }

        public String toString() {
            return "Binders.defaultBinder";
        }
    }

    private static final class DateBinder
    implements Binder {
        private DateBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof java.sql.Date) {
                stmt.setDate(param, (java.sql.Date)value);
            } else if (value instanceof Date) {
                stmt.setDate(param, new java.sql.Date(((Date)value).getTime()));
            } else if (value instanceof Calendar) {
                stmt.setDate(param, new java.sql.Date(((Calendar)value).getTimeInMillis()));
            } else if (value instanceof String) {
                stmt.setDate(param, java.sql.Date.valueOf((String)value));
            } else {
                stmt.setObject(param, value);
            }
        }

        public String toString() {
            return "Binders.dateBinder";
        }
    }

    private static final class TimestampBinder
    implements Binder {
        private static final int MIN_NUMBER_OF_CHARS_FOR_TIMESTAMP = 19;

        private TimestampBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof Timestamp) {
                stmt.setTimestamp(param, (Timestamp)value);
            } else if (value instanceof Date) {
                stmt.setTimestamp(param, new Timestamp(((Date)value).getTime()));
            } else if (value instanceof Calendar) {
                stmt.setTimestamp(param, new Timestamp(((Calendar)value).getTimeInMillis()));
            } else if (value instanceof String) {
                String valueAsString = (String)value;
                if (valueAsString.length() >= 19) {
                    stmt.setTimestamp(param, Timestamp.valueOf(valueAsString));
                } else {
                    java.sql.Date valueAsDate = java.sql.Date.valueOf(valueAsString);
                    stmt.setTimestamp(param, new Timestamp(valueAsDate.getTime()));
                }
            } else {
                stmt.setObject(param, value);
            }
        }

        public String toString() {
            return "Binders.timestampBinder";
        }
    }

    private static final class DecimalBinder
    implements Binder {
        private DecimalBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof String) {
                stmt.setBigDecimal(param, new BigDecimal((String)value));
            } else {
                stmt.setObject(param, value);
            }
        }

        public String toString() {
            return "Binders.decimalBinder";
        }
    }

    private static final class IntegerBinder
    implements Binder {
        private IntegerBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof BigInteger) {
                stmt.setObject(param, value, -5);
            } else if (value instanceof Enum) {
                stmt.setInt(param, ((Enum)value).ordinal());
            } else if (value instanceof String) {
                stmt.setObject(param, (Object)new BigInteger((String)value), -5);
            } else {
                stmt.setObject(param, value);
            }
        }

        public String toString() {
            return "Binders.integerBinder";
        }
    }

    private static final class TimeBinder
    implements Binder {
        private TimeBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof Time) {
                stmt.setTime(param, (Time)value);
            } else if (value instanceof Date) {
                stmt.setTime(param, new Time(((Date)value).getTime()));
            } else if (value instanceof Calendar) {
                stmt.setTime(param, new Time(((Calendar)value).getTimeInMillis()));
            } else if (value instanceof String) {
                stmt.setTime(param, Time.valueOf((String)value));
            } else {
                stmt.setObject(param, value);
            }
        }

        public String toString() {
            return "Binders.timeBinder";
        }
    }

    private static final class StringBinder
    implements Binder {
        private StringBinder() {
        }

        @Override
        public void bind(PreparedStatement stmt, int param, Object value) throws SQLException {
            if (value instanceof String) {
                stmt.setString(param, (String)value);
            } else if (value instanceof Enum) {
                stmt.setString(param, ((Enum)value).name());
            } else if (value == null) {
                stmt.setObject(param, null);
            } else {
                stmt.setString(param, value.toString());
            }
        }

        public String toString() {
            return "Binders.stringBinder";
        }
    }
}

