/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.bind;

import com.ninja_squad.dbsetup.bind.Binder;
import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.bind.Binders;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class DefaultBinderConfiguration
implements BinderConfiguration {
    public static final DefaultBinderConfiguration INSTANCE = new DefaultBinderConfiguration();

    protected DefaultBinderConfiguration() {
    }

    @Override
    public Binder getBinder(ParameterMetaData metadata, int param) throws SQLException {
        if (metadata == null) {
            return Binders.defaultBinder();
        }
        try {
            int sqlType = metadata.getParameterType(param);
            if (sqlType == 91) {
                return Binders.dateBinder();
            }
            if (sqlType == 92) {
                return Binders.timeBinder();
            }
            if (sqlType == 93) {
                return Binders.timestampBinder();
            }
            if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
                return Binders.integerBinder();
            }
            if (sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 2 || sqlType == 7) {
                return Binders.decimalBinder();
            }
            if (sqlType == 12 || sqlType == 1 || sqlType == -16 || sqlType == -1 || sqlType == -15 || sqlType == -9) {
                return Binders.stringBinder();
            }
            return Binders.defaultBinder();
        }
        catch (SQLException e) {
            return Binders.defaultBinder();
        }
    }

    public String toString() {
        return "DefaultBinderConfiguration";
    }
}

