/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.generator;

import com.ninja_squad.dbsetup.generator.ValueGenerator;
import com.ninja_squad.dbsetup.util.Preconditions;

public final class StringSequenceValueGenerator
implements ValueGenerator<String> {
    private String prefix;
    private long next;
    private int increment;
    private int paddedNumberLength;

    StringSequenceValueGenerator(String prefix) {
        this(prefix, 1L, 1, 0);
    }

    private StringSequenceValueGenerator(String prefix, long next, int increment, int paddedNumberLength) {
        this.prefix = prefix;
        this.next = next;
        this.increment = increment;
        this.paddedNumberLength = paddedNumberLength;
    }

    public StringSequenceValueGenerator withLeftPadding(int paddedNumberLength) {
        Preconditions.checkArgument(paddedNumberLength > 0, "paddedNumberLength must be > 0");
        this.paddedNumberLength = paddedNumberLength;
        return this;
    }

    public StringSequenceValueGenerator withoutLeftPadding() {
        this.paddedNumberLength = 0;
        return this;
    }

    public StringSequenceValueGenerator startingAt(long start) {
        this.next = start;
        return this;
    }

    public StringSequenceValueGenerator incrementingBy(int increment) {
        this.increment = increment;
        return this;
    }

    @Override
    public String nextValue() {
        long number = this.next;
        this.next += (long)this.increment;
        return this.prefix + this.leftPadIfNecessary(number);
    }

    private String leftPadIfNecessary(long number) {
        String numberAsString = Long.toString(number);
        if (numberAsString.length() >= this.paddedNumberLength) {
            return numberAsString;
        }
        StringBuilder builder = new StringBuilder(this.paddedNumberLength);
        for (int i = 0; i < this.paddedNumberLength - numberAsString.length(); ++i) {
            builder.append('0');
        }
        return builder.append(numberAsString).toString();
    }

    public String toString() {
        return "StringSequenceValueGenerator[prefix='" + this.prefix + '\'' + ", next=" + this.next + ", increment=" + this.increment + ", paddedNumberLength=" + this.paddedNumberLength + "]";
    }
}

