/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.generator;

import com.ninja_squad.dbsetup.generator.DateSequenceValueGenerator;
import com.ninja_squad.dbsetup.generator.SequenceValueGenerator;
import com.ninja_squad.dbsetup.generator.StringSequenceValueGenerator;
import com.ninja_squad.dbsetup.generator.ValueGenerator;
import com.ninja_squad.dbsetup.util.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ValueGenerators {
    private ValueGenerators() {
    }

    public static SequenceValueGenerator sequence() {
        return new SequenceValueGenerator();
    }

    public static <T> ValueGenerator<T> constant(final @Nullable T constant) {
        return new ValueGenerator<T>(){

            @Override
            public T nextValue() {
                return constant;
            }

            public String toString() {
                return "ValueGenerators.constant(" + constant + ")";
            }
        };
    }

    public static StringSequenceValueGenerator stringSequence(@Nonnull String prefix) {
        Preconditions.checkNotNull(prefix, "prefix may not be null");
        return new StringSequenceValueGenerator(prefix);
    }

    public static DateSequenceValueGenerator dateSequence() {
        return new DateSequenceValueGenerator();
    }
}

