/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.destination;

import com.ninja_squad.dbsetup.destination.Destination;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;

@Immutable
public final class DataSourceDestination
implements Destination {
    private final DataSource dataSource;

    public DataSourceDestination(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull(dataSource, "dataSource may not be null");
        this.dataSource = dataSource;
    }

    public static DataSourceDestination with(@Nonnull DataSource dataSource) {
        return new DataSourceDestination(dataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public String toString() {
        return "DataSourceDestination [dataSource=" + this.dataSource + "]";
    }

    public int hashCode() {
        return this.dataSource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSourceDestination other = (DataSourceDestination)obj;
        return this.dataSource.equals(other.dataSource);
    }
}

