/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.operation;

import com.ninja_squad.dbsetup.bind.Binder;
import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.generator.ValueGenerator;
import com.ninja_squad.dbsetup.generator.ValueGenerators;
import com.ninja_squad.dbsetup.operation.Operation;
import com.ninja_squad.dbsetup.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Insert
implements Operation {
    private final String table;
    private final List<String> columnNames;
    private final Map<String, List<Object>> generatedValues;
    private final List<List<?>> rows;
    private final boolean metadataUsed;
    private final Map<String, Binder> binders;

    private Insert(Builder builder) {
        this.table = builder.table;
        this.columnNames = builder.columnNames;
        this.rows = builder.rows;
        this.generatedValues = this.generateValues(builder.valueGenerators, this.rows.size());
        this.binders = builder.binders;
        this.metadataUsed = builder.metadataUsed;
    }

    private Map<String, List<Object>> generateValues(Map<String, ValueGenerator<?>> valueGenerators, int count) {
        LinkedHashMap<String, List<Object>> result = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, ValueGenerator<?>> entry : valueGenerators.entrySet()) {
            result.put(entry.getKey(), this.generateValues(entry.getValue(), count));
        }
        return result;
    }

    private List<Object> generateValues(ValueGenerator<?> valueGenerator, int count) {
        ArrayList<Object> result = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            result.add(valueGenerator.nextValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The point here is precisely to compose a SQL String from column names coming from the user")
    public void execute(Connection connection, BinderConfiguration configuration) throws SQLException {
        ArrayList<String> allColumnNames = new ArrayList<String>(this.columnNames);
        allColumnNames.addAll(this.generatedValues.keySet());
        String query = this.generateSqlQuery(allColumnNames);
        PreparedStatement stmt = connection.prepareStatement(query);
        try {
            Map<String, Binder> usedBinders = this.initializeBinders(stmt, allColumnNames, configuration);
            int rowIndex = 0;
            for (List<?> row : this.rows) {
                String columnName;
                int i = 0;
                for (Object obj : row) {
                    columnName = this.columnNames.get(i);
                    Binder binder = usedBinders.get(columnName);
                    binder.bind(stmt, i + 1, obj);
                    ++i;
                }
                for (Map.Entry entry : this.generatedValues.entrySet()) {
                    columnName = (String)entry.getKey();
                    List rowValues = (List)entry.getValue();
                    Binder binder = usedBinders.get(columnName);
                    binder.bind(stmt, i + 1, rowValues.get(rowIndex));
                    ++i;
                }
                stmt.executeUpdate();
                ++rowIndex;
            }
        }
        finally {
            stmt.close();
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    private String generateSqlQuery(List<String> allColumnNames) {
        StringBuilder sql = new StringBuilder("insert into ").append(this.table).append(" (");
        Iterator<String> it = allColumnNames.iterator();
        while (it.hasNext()) {
            String columnName = it.next();
            sql.append(columnName);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") values (");
        it = allColumnNames.iterator();
        while (it.hasNext()) {
            it.next();
            sql.append('?');
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(')');
        return sql.toString();
    }

    private Map<String, Binder> initializeBinders(PreparedStatement stmt, List<String> allColumnNames, BinderConfiguration configuration) throws SQLException {
        HashMap<String, Binder> result = new HashMap<String, Binder>();
        ParameterMetaData metadata = null;
        if (this.metadataUsed) {
            try {
                metadata = stmt.getParameterMetaData();
            }
            catch (SQLException e) {
                metadata = null;
            }
        }
        int i = 1;
        for (String columnName : allColumnNames) {
            Binder binder = this.binders.get(columnName);
            if (binder == null && (binder = configuration.getBinder(metadata, i)) == null) {
                throw new IllegalStateException("null binder returned from configuration " + configuration.getClass());
            }
            result.put(columnName, binder);
            ++i;
        }
        return result;
    }

    public String toString() {
        return "insert into " + this.table + " [columns=" + this.columnNames + ", generatedValues=" + this.generatedValues + ", rows=" + this.rows + ", metadataUsed=" + this.metadataUsed + ", binders=" + this.binders + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.binders).hashCode();
        result = 31 * result + ((Object)this.columnNames).hashCode();
        result = 31 * result + ((Object)this.generatedValues).hashCode();
        result = 31 * result + Boolean.valueOf(this.metadataUsed).hashCode();
        result = 31 * result + ((Object)this.rows).hashCode();
        result = 31 * result + this.table.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Insert other = (Insert)obj;
        return ((Object)this.binders).equals(other.binders) && ((Object)this.columnNames).equals(other.columnNames) && ((Object)this.generatedValues).equals(other.generatedValues) && this.metadataUsed == other.metadataUsed && ((Object)this.rows).equals(other.rows) && this.table.equals(other.table);
    }

    public static Builder into(@Nonnull String table) {
        Preconditions.checkNotNull(table, "table may not be null");
        return new Builder(table);
    }

    private static final class MapRowRepeater
    extends AbstractRowRepeater {
        private final Map<String, ?> values;

        private MapRowRepeater(Builder builder, Map<String, ?> values) {
            super(builder);
            this.values = values;
        }

        @Override
        public Builder doTimes(int times) {
            return this.builder.addRepeatingValues(this.values, times);
        }
    }

    private static final class ListRowRepeater
    extends AbstractRowRepeater {
        private final List<Object> values;

        private ListRowRepeater(Builder builder, List<Object> values) {
            super(builder);
            this.values = values;
        }

        @Override
        public Builder doTimes(int times) {
            return this.builder.addRepeatingValues(this.values, times);
        }
    }

    private static abstract class AbstractRowRepeater
    implements RowRepeater {
        protected final Builder builder;
        private boolean ended;

        public AbstractRowRepeater(Builder builder) {
            this.builder = builder;
        }

        protected abstract Builder doTimes(int var1);

        @Override
        public Builder times(int times) {
            Preconditions.checkArgument(times >= 0, "the number of repeating values must be >= 0");
            Preconditions.checkState(!this.ended, "The rows have already been ended and added to the Insert Builder");
            this.ended = true;
            return this.doTimes(times);
        }
    }

    public static interface RowRepeater {
        public Builder times(int var1);
    }

    public static final class RowBuilder {
        private final Builder builder;
        private final Map<String, Object> row;
        private boolean ended;

        private RowBuilder(Builder builder) {
            this.builder = builder;
            this.row = new LinkedHashMap<String, Object>();
        }

        public RowBuilder column(@Nonnull String name, Object value) {
            Preconditions.checkState(!this.ended, "The row has already been ended and added to the Insert Builder");
            if (!this.builder.columnNames.isEmpty()) {
                Preconditions.checkNotNull(name, "the column name may not be null");
                Preconditions.checkArgument(this.builder.columnNames.contains(name), "column " + name + " is not one of the registered column names");
            }
            this.row.put(name, value);
            return this;
        }

        public Builder end() {
            Preconditions.checkState(!this.ended, "The row has already been ended and added to the Insert Builder");
            this.ended = true;
            return this.builder.values(this.row);
        }

        public Builder times(int times) {
            Preconditions.checkArgument(times >= 0, "the number of repeating values must be >= 0");
            Preconditions.checkState(!this.ended, "The row has already been ended and added to the Insert Builder");
            this.ended = true;
            return this.builder.addRepeatingValues(this.row, times);
        }
    }

    public static final class Builder {
        private final String table;
        private final List<String> columnNames = new ArrayList<String>();
        private final Map<String, ValueGenerator<?>> valueGenerators = new LinkedHashMap();
        private final List<List<?>> rows = new ArrayList();
        private boolean metadataUsed = true;
        private final Map<String, Binder> binders = new HashMap<String, Binder>();
        private boolean built;

        private Builder(String table) {
            this.table = table;
        }

        public Builder columns(String ... columns) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkState(this.columnNames.isEmpty(), "columns have already been specified");
            for (String column : columns) {
                Preconditions.checkNotNull(column, "column may not be null");
                Preconditions.checkState(!this.valueGenerators.containsKey(column), "column " + column + " has already been specified as generated value column");
            }
            this.columnNames.addAll(Arrays.asList(columns));
            return this;
        }

        public Builder values(Object ... values) {
            return this.addRepeatingValues(Arrays.asList(values), 1);
        }

        public RowRepeater repeatingValues(Object ... values) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkArgument(values.length == this.columnNames.size(), "The number of values doesn't match the number of columns");
            return new ListRowRepeater(this, Arrays.asList(values));
        }

        public RowBuilder row() {
            Preconditions.checkState(!this.built, "The insert has already been built");
            return new RowBuilder(this);
        }

        public Builder values(@Nonnull Map<String, ?> row) {
            return this.addRepeatingValues(row, 1);
        }

        public RowRepeater repeatingValues(@Nonnull Map<String, ?> row) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkNotNull(row, "The row may not be null");
            return new MapRowRepeater(this, row);
        }

        public Builder withBinder(@Nonnull Binder binder, String ... columns) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkNotNull(binder, "binder may not be null");
            for (String columnName : columns) {
                Preconditions.checkArgument(this.columnNames.contains(columnName) || this.valueGenerators.containsKey(columnName), "column " + columnName + " is not one of the registered column names");
                this.binders.put(columnName, binder);
            }
            return this;
        }

        public Builder withDefaultValue(@Nonnull String column, Object value) {
            return this.withGeneratedValue(column, ValueGenerators.constant(value));
        }

        public Builder withGeneratedValue(@Nonnull String column, @Nonnull ValueGenerator<?> valueGenerator) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkNotNull(column, "column may not be null");
            Preconditions.checkNotNull(valueGenerator, "valueGenerator may not be null");
            Preconditions.checkArgument(!this.columnNames.contains(column), "column " + column + " is already listed in the list of column names");
            this.valueGenerators.put(column, valueGenerator);
            return this;
        }

        public Builder useMetadata(boolean useMetadata) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            this.metadataUsed = useMetadata;
            return this;
        }

        public Insert build() {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkState(!this.columnNames.isEmpty() || !this.valueGenerators.isEmpty(), "no column and no generated value column has been specified");
            this.built = true;
            return new Insert(this);
        }

        public String toString() {
            return "insert into " + this.table + " [columns=" + this.columnNames + ", rows=" + this.rows + ", valueGenerators=" + this.valueGenerators + ", metadataUsed=" + this.metadataUsed + ", binders=" + this.binders + ", built=" + this.built + "]";
        }

        private Builder addRepeatingValues(List<?> values, int times) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkArgument(values.size() == this.columnNames.size(), "The number of values doesn't match the number of columns");
            ArrayList row = new ArrayList(values);
            for (int i = 0; i < times; ++i) {
                this.rows.add(row);
            }
            return this;
        }

        private Builder addRepeatingValues(@Nonnull Map<String, ?> row, int times) {
            Preconditions.checkState(!this.built, "The insert has already been built");
            Preconditions.checkNotNull(row, "The row may not be null");
            List<Object> values = this.mapToRow(row);
            for (int i = 0; i < times; ++i) {
                this.rows.add(values);
            }
            return this;
        }

        private List<Object> mapToRow(@Nonnull Map<String, ?> row) {
            boolean setColumns;
            boolean bl = setColumns = this.rows.isEmpty() && this.columnNames.isEmpty();
            if (setColumns) {
                this.columns(row.keySet().toArray(new String[row.size()]));
            } else {
                HashSet<String> rowColumnNames = new HashSet<String>(row.keySet());
                rowColumnNames.removeAll(this.columnNames);
                if (!rowColumnNames.isEmpty()) {
                    throw new IllegalArgumentException("The following columns of the row don't match with any column name: " + rowColumnNames);
                }
            }
            ArrayList<Object> values = new ArrayList<Object>(this.columnNames.size());
            for (String columnName : this.columnNames) {
                values.add(row.get(columnName));
            }
            return values;
        }
    }
}

