/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.operation;

import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.operation.CompositeOperation;
import com.ninja_squad.dbsetup.operation.Operation;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Truncate
implements Operation {
    private final String tableToTruncate;

    private Truncate(String table) {
        this.tableToTruncate = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, BinderConfiguration configuration) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate("truncate table " + this.tableToTruncate);
        }
    }

    public static Truncate table(@Nonnull String table) {
        return new Truncate(table);
    }

    public static Operation tables(String ... tables) {
        return Truncate.tables(Arrays.asList(tables));
    }

    public static Operation tables(List<String> tables) {
        ArrayList<Truncate> operations = new ArrayList<Truncate>(tables.size());
        for (String table : tables) {
            operations.add(new Truncate(table));
        }
        return CompositeOperation.sequenceOf(operations);
    }

    public String toString() {
        return "truncate table " + this.tableToTruncate;
    }

    public int hashCode() {
        return this.tableToTruncate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Truncate other = (Truncate)obj;
        return this.tableToTruncate.equals(other.tableToTruncate);
    }
}

