/*
 * Decompiled with CFR 0.152.
 */
package com.ninjasquad.springmockk;

import com.ninjasquad.springmockk.Definition;
import com.ninjasquad.springmockk.DefinitionsParser;
import com.ninjasquad.springmockk.MockkBean;
import com.ninjasquad.springmockk.MockkClear;
import com.ninjasquad.springmockk.MockkDefinition;
import com.ninjasquad.springmockk.QualifierDefinition;
import com.ninjasquad.springmockk.SpykBean;
import com.ninjasquad.springmockk.SpykDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0004J=\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020\u00112\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J&\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J&\u0010%\u001a\u00020\u00112\u0006\u0010#\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/ninjasquad/springmockk/DefinitionsParser;", "", "existing", "", "Lcom/ninjasquad/springmockk/Definition;", "(Ljava/util/Collection;)V", "definitionFields", "", "Ljava/lang/reflect/Field;", "definitions", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "parsedDefinitions", "", "getParsedDefinitions", "()Ljava/util/Set;", "addDefinition", "", "element", "Ljava/lang/reflect/AnnotatedElement;", "definition", "type", "", "getField", "getOrDeduceTypes", "Lorg/springframework/core/ResolvableType;", "value", "", "Lkotlin/reflect/KClass;", "source", "Ljava/lang/Class;", "(Ljava/lang/reflect/AnnotatedElement;[Lkotlin/reflect/KClass;Ljava/lang/Class;)Ljava/util/Set;", "parse", "parseElement", "parseMockkBeanAnnotation", "annotation", "Lcom/ninjasquad/springmockk/MockkBean;", "parseSpykBeanAnnotation", "Lcom/ninjasquad/springmockk/SpykBean;", "springmockk"})
public final class DefinitionsParser {
    private final LinkedHashSet<Definition> definitions;
    private final Map<Definition, Field> definitionFields;

    @NotNull
    public final Set<Definition> getParsedDefinitions() {
        Set<Definition> set = Collections.unmodifiableSet((Set)this.definitions);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(definitions)");
        return set;
    }

    public final void parse(@NotNull Class<?> source) {
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        this.parseElement(source, null);
        ReflectionUtils.doWithFields(source, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(this, source){
            final /* synthetic */ DefinitionsParser this$0;
            final /* synthetic */ Class $source;

            public final void doWith(@NotNull Field element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                DefinitionsParser.access$parseElement(this.this$0, element, this.$source);
            }
            {
                this.this$0 = definitionsParser;
                this.$source = clazz;
            }
        });
    }

    private final void parseElement(AnnotatedElement element, Class<?> source) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
        Intrinsics.checkExpressionValueIsNotNull((Object)mergedAnnotations, (String)"MergedAnnotations.from(\n\u2026tegy.SUPERCLASS\n        )");
        MergedAnnotations annotations = mergedAnnotations;
        annotations.stream(MockkBean.class).map(parseElement.1.INSTANCE).forEach((Consumer)new Consumer<MockkBean>(this, element, source){
            final /* synthetic */ DefinitionsParser this$0;
            final /* synthetic */ AnnotatedElement $element;
            final /* synthetic */ Class $source;

            public final void accept(MockkBean it) {
                MockkBean mockkBean = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mockkBean, (String)"it");
                DefinitionsParser.access$parseMockkBeanAnnotation(this.this$0, mockkBean, this.$element, this.$source);
            }
            {
                this.this$0 = definitionsParser;
                this.$element = annotatedElement;
                this.$source = clazz;
            }
        });
        annotations.stream(SpykBean.class).map(parseElement.3.INSTANCE).forEach((Consumer)new Consumer<SpykBean>(this, element, source){
            final /* synthetic */ DefinitionsParser this$0;
            final /* synthetic */ AnnotatedElement $element;
            final /* synthetic */ Class $source;

            public final void accept(SpykBean it) {
                SpykBean spykBean = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)spykBean, (String)"it");
                DefinitionsParser.access$parseSpykBeanAnnotation(this.this$0, spykBean, this.$element, this.$source);
            }
            {
                this.this$0 = definitionsParser;
                this.$element = annotatedElement;
                this.$source = clazz;
            }
        });
    }

    private final void parseMockkBeanAnnotation(MockkBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToMock = this.getOrDeduceTypes(element, Reflection.getOrCreateKotlinClasses((Class[])annotation.value()), source);
        boolean bl = !typesToMock.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unable to deduce type to mock from " + element;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (StringUtils.hasLength((String)annotation.name())) {
            bl = typesToMock.size() == 1;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "The name attribute can only be used when mocking a single class";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        for (ResolvableType typeToMock : typesToMock) {
            CharSequence charSequence = annotation.name();
            boolean bl6 = false;
            boolean bl7 = charSequence.length() == 0;
            QualifierDefinition qualifierDefinition = QualifierDefinition.Companion.forElement(element);
            boolean bl8 = annotation.relaxUnitFun();
            boolean bl9 = annotation.relaxed();
            MockkClear mockkClear = annotation.clear();
            KClass[] kClassArray = Reflection.getOrCreateKotlinClasses((Class[])annotation.extraInterfaces());
            ResolvableType resolvableType = typeToMock;
            String string = bl7 ? null : annotation.name();
            MockkDefinition definition = new MockkDefinition(string, resolvableType, kClassArray, mockkClear, bl9, bl8, qualifierDefinition);
            this.addDefinition(element, definition, "mock");
        }
    }

    private final void parseSpykBeanAnnotation(SpykBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToSpy = this.getOrDeduceTypes(element, Reflection.getOrCreateKotlinClasses((Class[])annotation.value()), source);
        Assert.state((!typesToSpy.isEmpty() ? 1 : 0) != 0, (Supplier)new Supplier<String>(element){
            final /* synthetic */ AnnotatedElement $element;

            @NotNull
            public final String get() {
                return "Unable to deduce type to spy from " + this.$element;
            }
            {
                this.$element = annotatedElement;
            }
        });
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((typesToSpy.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when spying a single class");
        }
        for (ResolvableType typeToSpy : typesToSpy) {
            CharSequence charSequence = annotation.name();
            boolean bl = false;
            boolean bl2 = charSequence.length() == 0;
            QualifierDefinition qualifierDefinition = QualifierDefinition.Companion.forElement(element);
            MockkClear mockkClear = annotation.clear();
            ResolvableType resolvableType = typeToSpy;
            String string = bl2 ? null : annotation.name();
            SpykDefinition definition = new SpykDefinition(string, resolvableType, mockkClear, qualifierDefinition);
            this.addDefinition(element, definition, "spy");
        }
    }

    private final void addDefinition(AnnotatedElement element, Definition definition, String type) {
        boolean isNewDefinition = this.definitions.add(definition);
        Assert.state((boolean)isNewDefinition, (Supplier)new Supplier<String>(type, definition){
            final /* synthetic */ String $type;
            final /* synthetic */ Definition $definition;

            @NotNull
            public final String get() {
                return "Duplicate " + this.$type + " definition " + this.$definition;
            }
            {
                this.$type = string;
                this.$definition = definition;
            }
        });
        if (element instanceof Field) {
            this.definitionFields.put(definition, (Field)element);
        }
    }

    private final Set<ResolvableType> getOrDeduceTypes(AnnotatedElement element, KClass<?>[] value, Class<?> source) {
        LinkedHashSet<ResolvableType> types = new LinkedHashSet<ResolvableType>();
        for (KClass<?> clazz : value) {
            types.add(ResolvableType.forClass((Class)JvmClassMappingKt.getJavaClass(clazz)));
        }
        if (types.isEmpty() && element instanceof Field) {
            ResolvableType resolvableType;
            AnnotatedElement field = element;
            if (((Field)field).getGenericType() instanceof TypeVariable) {
                Field field2 = (Field)field;
                Class<?> clazz = source;
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                resolvableType = ResolvableType.forField((Field)field2, clazz);
            } else {
                resolvableType = ResolvableType.forField((Field)((Field)field));
            }
            types.add(resolvableType);
        }
        return types;
    }

    @Nullable
    public final Field getField(@NotNull Definition definition) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        return this.definitionFields.get(definition);
    }

    public DefinitionsParser(@NotNull Collection<? extends Definition> existing) {
        Map map;
        Intrinsics.checkParameterIsNotNull(existing, (String)"existing");
        this.definitions = new LinkedHashSet();
        DefinitionsParser definitionsParser = this;
        boolean bl = false;
        definitionsParser.definitionFields = map = (Map)new LinkedHashMap();
        this.definitions.addAll(existing);
    }

    public /* synthetic */ DefinitionsParser(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = SetsKt.emptySet();
        }
        this(collection);
    }

    public DefinitionsParser() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$parseElement(DefinitionsParser $this, AnnotatedElement element, Class source) {
        $this.parseElement(element, source);
    }

    public static final /* synthetic */ void access$parseMockkBeanAnnotation(DefinitionsParser $this, MockkBean annotation, AnnotatedElement element, Class source) {
        $this.parseMockkBeanAnnotation(annotation, element, source);
    }

    public static final /* synthetic */ void access$parseSpykBeanAnnotation(DefinitionsParser $this, SpykBean annotation, AnnotatedElement element, Class source) {
        $this.parseSpykBeanAnnotation(annotation, element, source);
    }
}

