/*
 * Decompiled with CFR 0.152.
 */
package com.ninjasquad.springmockk;

import com.ninjasquad.springmockk.Definition;
import com.ninjasquad.springmockk.MockkBean;
import com.ninjasquad.springmockk.MockkDefinition;
import com.ninjasquad.springmockk.QualifierDefinition;
import com.ninjasquad.springmockk.SpykBean;
import com.ninjasquad.springmockk.SpykDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0004J=\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020\u00112\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J&\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J&\u0010%\u001a\u00020\u00112\u0006\u0010#\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/ninjasquad/springmockk/DefinitionsParser;", "", "existing", "", "Lcom/ninjasquad/springmockk/Definition;", "(Ljava/util/Collection;)V", "definitionFields", "", "Ljava/lang/reflect/Field;", "definitions", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "parsedDefinitions", "", "getParsedDefinitions", "()Ljava/util/Set;", "addDefinition", "", "element", "Ljava/lang/reflect/AnnotatedElement;", "definition", "type", "", "getField", "getOrDeduceTypes", "Lorg/springframework/core/ResolvableType;", "value", "", "Lkotlin/reflect/KClass;", "source", "Ljava/lang/Class;", "(Ljava/lang/reflect/AnnotatedElement;[Lkotlin/reflect/KClass;Ljava/lang/Class;)Ljava/util/Set;", "parse", "parseElement", "parseMockkBeanAnnotation", "annotation", "Lcom/ninjasquad/springmockk/MockkBean;", "parseSpykBeanAnnotation", "Lcom/ninjasquad/springmockk/SpykBean;", "springmockk"})
public final class DefinitionsParser {
    @NotNull
    private final LinkedHashSet<Definition> definitions;
    @NotNull
    private final Map<Definition, Field> definitionFields;

    public DefinitionsParser(@NotNull Collection<? extends Definition> existing) {
        Intrinsics.checkNotNullParameter(existing, (String)"existing");
        this.definitions = new LinkedHashSet();
        this.definitionFields = new LinkedHashMap();
        this.definitions.addAll(existing);
    }

    public /* synthetic */ DefinitionsParser(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = SetsKt.emptySet();
        }
        this(collection);
    }

    @NotNull
    public final Set<Definition> getParsedDefinitions() {
        Set<Definition> set = Collections.unmodifiableSet((Set)this.definitions);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(definitions)");
        return set;
    }

    public final void parse(@NotNull Class<?> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.parseElement(source, null);
        ReflectionUtils.doWithFields(source, arg_0 -> DefinitionsParser.parse$lambda-0(this, source, arg_0));
    }

    private final void parseElement(AnnotatedElement element, Class<?> source) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
        Intrinsics.checkNotNullExpressionValue((Object)mergedAnnotations, (String)"from(\n            elemen\u2026tegy.SUPERCLASS\n        )");
        MergedAnnotations annotations = mergedAnnotations;
        annotations.stream(MockkBean.class).map(DefinitionsParser::parseElement$lambda-1).forEach(arg_0 -> DefinitionsParser.parseElement$lambda-2(this, element, source, arg_0));
        annotations.stream(SpykBean.class).map(DefinitionsParser::parseElement$lambda-3).forEach(arg_0 -> DefinitionsParser.parseElement$lambda-4(this, element, source, arg_0));
    }

    private final void parseMockkBeanAnnotation(MockkBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToMock = this.getOrDeduceTypes(element, Reflection.getOrCreateKotlinClasses((Class[])annotation.value()), source);
        if (!(!typesToMock.isEmpty())) {
            boolean $i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$32 = false;
            String $i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$32 = Intrinsics.stringPlus((String)"Unable to deduce type to mock from ", (Object)element);
            throw new IllegalStateException($i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$32.toString());
        }
        if (StringUtils.hasLength((String)annotation.name()) && !(typesToMock.size() == 1)) {
            boolean $i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$42 = false;
            String $i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$42 = "The name attribute can only be used when mocking a single class";
            throw new IllegalStateException($i$a$-check-DefinitionsParser$parseMockkBeanAnnotation$42.toString());
        }
        for (ResolvableType typeToMock : typesToMock) {
            MockkDefinition definition = new MockkDefinition(((CharSequence)annotation.name()).length() == 0 ? null : annotation.name(), typeToMock, Reflection.getOrCreateKotlinClasses((Class[])annotation.extraInterfaces()), annotation.clear(), annotation.relaxed(), annotation.relaxUnitFun(), QualifierDefinition.Companion.forElement(element));
            this.addDefinition(element, definition, "mock");
        }
    }

    private final void parseSpykBeanAnnotation(SpykBean annotation, AnnotatedElement element, Class<?> source) {
        Set<ResolvableType> typesToSpy = this.getOrDeduceTypes(element, Reflection.getOrCreateKotlinClasses((Class[])annotation.value()), source);
        Assert.state((!typesToSpy.isEmpty() ? 1 : 0) != 0, () -> DefinitionsParser.parseSpykBeanAnnotation$lambda-7(element));
        if (StringUtils.hasLength((String)annotation.name())) {
            Assert.state((typesToSpy.size() == 1 ? 1 : 0) != 0, (String)"The name attribute can only be used when spying a single class");
        }
        for (ResolvableType typeToSpy : typesToSpy) {
            SpykDefinition definition = new SpykDefinition(((CharSequence)annotation.name()).length() == 0 ? null : annotation.name(), typeToSpy, annotation.clear(), QualifierDefinition.Companion.forElement(element));
            this.addDefinition(element, definition, "spy");
        }
    }

    private final void addDefinition(AnnotatedElement element, Definition definition, String type) {
        boolean isNewDefinition = this.definitions.add(definition);
        Assert.state((boolean)isNewDefinition, () -> DefinitionsParser.addDefinition$lambda-8(type, definition));
        if (element instanceof Field) {
            Map<Definition, Field> map = this.definitionFields;
            AnnotatedElement annotatedElement = element;
            map.put(definition, (Field)annotatedElement);
        }
    }

    private final Set<ResolvableType> getOrDeduceTypes(AnnotatedElement element, KClass<?>[] value, Class<?> source) {
        LinkedHashSet<ResolvableType> types = new LinkedHashSet<ResolvableType>();
        for (KClass<?> clazz : value) {
            types.add(ResolvableType.forClass((Class)JvmClassMappingKt.getJavaClass(clazz)));
        }
        if (types.isEmpty() && element instanceof Field) {
            ResolvableType resolvableType;
            AnnotatedElement field = element;
            if (((Field)field).getGenericType() instanceof TypeVariable) {
                Field field2 = (Field)field;
                Class<?> clazz = source;
                Intrinsics.checkNotNull(clazz);
                resolvableType = ResolvableType.forField((Field)field2, clazz);
            } else {
                resolvableType = ResolvableType.forField((Field)((Field)field));
            }
            types.add(resolvableType);
        }
        return types;
    }

    @Nullable
    public final Field getField(@NotNull Definition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return this.definitionFields.get(definition);
    }

    private static final void parse$lambda-0(DefinitionsParser this$0, Class $source, Field element) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this$0.parseElement(element, $source);
    }

    private static final MockkBean parseElement$lambda-1(MergedAnnotation it) {
        return (MockkBean)it.synthesize();
    }

    private static final void parseElement$lambda-2(DefinitionsParser this$0, AnnotatedElement $element, Class $source, MockkBean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.parseMockkBeanAnnotation(it, $element, $source);
    }

    private static final SpykBean parseElement$lambda-3(MergedAnnotation it) {
        return (SpykBean)it.synthesize();
    }

    private static final void parseElement$lambda-4(DefinitionsParser this$0, AnnotatedElement $element, Class $source, SpykBean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.parseSpykBeanAnnotation(it, $element, $source);
    }

    private static final String parseSpykBeanAnnotation$lambda-7(AnnotatedElement $element) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        return Intrinsics.stringPlus((String)"Unable to deduce type to spy from ", (Object)$element);
    }

    private static final String addDefinition$lambda-8(String $type, Definition $definition) {
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$definition, (String)"$definition");
        return "Duplicate " + $type + " definition " + $definition;
    }

    public DefinitionsParser() {
        this(null, 1, null);
    }
}

