/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nispok.snackbar.R;
import com.nispok.snackbar.enums.SnackbarType;
import com.nispok.snackbar.listeners.ActionClickListener;
import com.nispok.snackbar.listeners.EventListener;
import com.nispok.snackbar.listeners.SwipeDismissTouchListener;

public class Snackbar
extends RelativeLayout {
    private SnackbarType mType = SnackbarType.SINGLE_LINE;
    private SnackbarDuration mDuration = SnackbarDuration.LENGTH_LONG;
    private CharSequence mText;
    private int mColor = -1;
    private int mTextColor = -1;
    private CharSequence mActionLabel;
    private int mActionColor = -1;
    private boolean mAnimated = true;
    private long mCustomDuration = -1L;
    private ActionClickListener mActionClickListener;
    private boolean mShouldDismissOnActionClicked = true;
    private EventListener mEventListener;
    private boolean mIsShowing = false;
    private boolean mCanSwipeToDismiss = true;
    private boolean mIsDismissing = false;

    private Snackbar(Context context) {
        super(context);
    }

    public static Snackbar with(Context context) {
        return new Snackbar(context);
    }

    public Snackbar type(SnackbarType type) {
        this.mType = type;
        return this;
    }

    public Snackbar text(CharSequence text) {
        this.mText = text;
        return this;
    }

    public Snackbar color(int color2) {
        this.mColor = color2;
        return this;
    }

    public Snackbar textColor(int textColor) {
        this.mTextColor = textColor;
        return this;
    }

    public Snackbar actionLabel(CharSequence actionButtonLabel) {
        this.mActionLabel = actionButtonLabel;
        return this;
    }

    public Snackbar actionColor(int actionColor) {
        this.mActionColor = actionColor;
        return this;
    }

    public Snackbar dismissOnActionClicked(boolean shouldDismiss) {
        this.mShouldDismissOnActionClicked = shouldDismiss;
        return this;
    }

    public Snackbar actionListener(ActionClickListener listener) {
        this.mActionClickListener = listener;
        return this;
    }

    public Snackbar eventListener(EventListener listener) {
        this.mEventListener = listener;
        return this;
    }

    public Snackbar animation(boolean withAnimation) {
        this.mAnimated = withAnimation;
        return this;
    }

    public Snackbar swipeToDismiss(boolean canSwipeToDismiss) {
        this.mCanSwipeToDismiss = canSwipeToDismiss;
        return this;
    }

    public Snackbar duration(SnackbarDuration duration) {
        this.mDuration = duration;
        return this;
    }

    public Snackbar duration(long duration) {
        this.mCustomDuration = duration;
        return this;
    }

    private void init(Activity parent) {
        RelativeLayout layout2 = (RelativeLayout)LayoutInflater.from((Context)parent).inflate(R.layout.sb__template, (ViewGroup)this, true);
        layout2.setBackgroundColor(this.mColor != -1 ? this.mColor : this.getResources().getColor(R.color.sb__background));
        int height = this.mType.getHeightInPx(this.getResources().getDisplayMetrics().density);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, height);
        layout2.setLayoutParams((ViewGroup.LayoutParams)params);
        TextView snackbarText = (TextView)layout2.findViewById(R.id.sb__text);
        snackbarText.setText(this.mText);
        if (this.mTextColor != -1) {
            snackbarText.setTextColor(this.mTextColor);
        }
        snackbarText.setMaxLines(this.mType.getMaxLines());
        TextView snackbarAction = (TextView)layout2.findViewById(R.id.sb__action);
        if (!TextUtils.isEmpty((CharSequence)this.mActionLabel)) {
            this.requestLayout();
            snackbarAction.setText(this.mActionLabel);
            if (this.mActionColor != -1) {
                snackbarAction.setTextColor(this.mActionColor);
            }
            snackbarAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (Snackbar.this.mActionClickListener != null) {
                        Snackbar.this.mActionClickListener.onActionClicked();
                    }
                    if (Snackbar.this.mShouldDismissOnActionClicked) {
                        Snackbar.this.dismiss();
                    }
                }
            });
            snackbarAction.setMaxLines(this.mType.getMaxLines());
        } else {
            snackbarAction.setVisibility(8);
        }
        this.setClickable(true);
        if (this.mCanSwipeToDismiss) {
            this.setOnTouchListener(new SwipeDismissTouchListener((View)this, null, new SwipeDismissTouchListener.DismissCallbacks(){

                @Override
                public boolean canDismiss(Object token) {
                    return true;
                }

                @Override
                public void onDismiss(View view, Object token) {
                    if (view != null) {
                        Snackbar.this.finish();
                    }
                }
            }));
        }
    }

    public void show(Activity targetActivity) {
        this.init(targetActivity);
        ViewGroup root = (ViewGroup)targetActivity.findViewById(0x1020002);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        root.addView((View)this, (ViewGroup.LayoutParams)params);
        this.mIsShowing = true;
        if (this.mEventListener != null) {
            this.mEventListener.onShow(this.mType.getHeight());
        }
        if (!this.mAnimated) {
            this.startTimer();
            return;
        }
        Animation slideIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.snackbar_in);
        slideIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                Snackbar.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Snackbar.this.startTimer();
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(slideIn);
    }

    private void startTimer() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                Snackbar.this.dismiss();
            }
        }, this.getDuration());
    }

    public void dismiss() {
        if (!this.mAnimated) {
            this.finish();
            return;
        }
        if (this.mIsDismissing) {
            return;
        }
        Animation slideOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.snackbar_out);
        slideOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                Snackbar.this.mIsDismissing = true;
            }

            public void onAnimationEnd(Animation animation) {
                Snackbar.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Snackbar.this.finish();
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(slideOut);
    }

    private void finish() {
        this.clearAnimation();
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.removeView((View)this);
        }
        if (this.mEventListener != null && this.mIsShowing) {
            this.mEventListener.onDismiss(this.mType.getHeight());
        }
        this.mIsShowing = false;
    }

    public int getActionColor() {
        return this.mActionColor;
    }

    public CharSequence getActionLabel() {
        return this.mActionLabel;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getColor() {
        return this.mColor;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public long getDuration() {
        return this.mCustomDuration == -1L ? this.mDuration.getDuration() : this.mCustomDuration;
    }

    public SnackbarType getType() {
        return this.mType;
    }

    public boolean isAnimated() {
        return this.mAnimated;
    }

    public boolean shouldDismissOnActionClicked() {
        return this.mShouldDismissOnActionClicked;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isDismissed() {
        return !this.mIsShowing;
    }

    public static enum SnackbarDuration {
        LENGTH_SHORT(2000L),
        LENGTH_LONG(3500L);

        private long duration;

        private SnackbarDuration(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

