/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import com.nispok.snackbar.DisplayCompatImplHoneycombMR2;
import com.nispok.snackbar.DisplayCompatImplJBMR1;
import com.nispok.snackbar.DisplayCompatImplPreHoneycombMR2;

class DisplayCompat {
    private static final Impl IMPL = Build.VERSION.SDK_INT >= 17 ? new DisplayCompatImplJBMR1() : (Build.VERSION.SDK_INT >= 13 ? new DisplayCompatImplHoneycombMR2() : new DisplayCompatImplPreHoneycombMR2());

    DisplayCompat() {
    }

    public static void getSize(Display display, Point outSize) {
        IMPL.getSize(display, outSize);
    }

    public static void getRealSize(Display display, Point outSize) {
        IMPL.getRealSize(display, outSize);
    }

    public static int getWidthFromPercentage(Activity targetActivity, Float mMaxWidthPercentage) {
        Display display = targetActivity.getWindowManager().getDefaultDisplay();
        Point dispSize = new Point();
        DisplayCompat.getRealSize(display, dispSize);
        return (int)((float)dispSize.x * mMaxWidthPercentage.floatValue());
    }

    static abstract class Impl {
        Impl() {
        }

        abstract void getSize(Display var1, Point var2);

        abstract void getRealSize(Display var1, Point var2);
    }
}

