/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nispok.snackbar.DisplayCompat;
import com.nispok.snackbar.R;
import com.nispok.snackbar.RecyclerUtil;
import com.nispok.snackbar.SnackbarHelperChildViewJB;
import com.nispok.snackbar.enums.SnackbarType;
import com.nispok.snackbar.layouts.SnackbarLayout;
import com.nispok.snackbar.listeners.ActionClickListener;
import com.nispok.snackbar.listeners.ActionSwipeListener;
import com.nispok.snackbar.listeners.EventListener;
import com.nispok.snackbar.listeners.SwipeDismissTouchListener;

public class Snackbar
extends SnackbarLayout {
    private int mUndefinedColor = -10000;
    private int mUndefinedDrawable = -10000;
    private SnackbarType mType = SnackbarType.SINGLE_LINE;
    private SnackbarDuration mDuration = SnackbarDuration.LENGTH_LONG;
    private CharSequence mText;
    private TextView snackbarText;
    private int mColor = this.mUndefinedColor;
    private int mTextColor = this.mUndefinedColor;
    private int mOffset;
    private SnackbarPosition mPosition = SnackbarPosition.BOTTOM;
    private int mDrawable = this.mUndefinedDrawable;
    private int mMarginTop = 0;
    private int mMarginBottom = 0;
    private int mMarginLeft = 0;
    private int mMarginRight = 0;
    private long mSnackbarStart;
    private long mSnackbarFinish;
    private long mTimeRemaining = -1L;
    private CharSequence mActionLabel;
    private int mActionColor = this.mUndefinedColor;
    private boolean mAnimated = true;
    private boolean mIsReplacePending = false;
    private boolean mIsShowingByReplace = false;
    private long mCustomDuration = -1L;
    private ActionClickListener mActionClickListener;
    private ActionSwipeListener mActionSwipeListener;
    private boolean mShouldAllowMultipleActionClicks;
    private boolean mActionClicked;
    private boolean mShouldDismissOnActionClicked = true;
    private EventListener mEventListener;
    private Typeface mTextTypeface;
    private Typeface mActionTypeface;
    private boolean mIsShowing = false;
    private boolean mCanSwipeToDismiss = true;
    private boolean mIsDismissing = false;
    private Rect mWindowInsets = new Rect();
    private Rect mDisplayFrame = new Rect();
    private Point mDisplaySize = new Point();
    private Point mRealDisplaySize = new Point();
    private Activity mTargetActivity;
    private Float mMaxWidthPercentage = null;
    private boolean mUsePhoneLayout;
    private Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            Snackbar.this.dismiss();
        }
    };
    private Runnable mRefreshLayoutParamsMarginsRunnable = new Runnable(){

        @Override
        public void run() {
            Snackbar.this.refreshLayoutParamsMargins();
        }
    };

    private Snackbar(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT >= 16) {
            this.addView(new SnackbarHelperChildViewJB(this.getContext()));
        }
    }

    public static Snackbar with(Context context) {
        return new Snackbar(context);
    }

    public Snackbar type(SnackbarType type) {
        this.mType = type;
        return this;
    }

    public Snackbar text(CharSequence text) {
        this.mText = text;
        if (this.snackbarText != null) {
            this.snackbarText.setText(this.mText);
        }
        return this;
    }

    public Snackbar text(int resId) {
        return this.text(this.getContext().getText(resId));
    }

    public Snackbar color(int color2) {
        this.mColor = color2;
        return this;
    }

    public Snackbar colorResource(int resId) {
        return this.color(this.getResources().getColor(resId));
    }

    public Snackbar backgroundDrawable(int resId) {
        this.mDrawable = resId;
        return this;
    }

    public Snackbar textColor(int textColor) {
        this.mTextColor = textColor;
        return this;
    }

    public Snackbar textColorResource(int resId) {
        return this.textColor(this.getResources().getColor(resId));
    }

    public Snackbar actionLabel(CharSequence actionButtonLabel) {
        this.mActionLabel = actionButtonLabel;
        return this;
    }

    public Snackbar actionLabel(int resId) {
        return this.actionLabel(this.getContext().getString(resId));
    }

    public Snackbar position(SnackbarPosition position) {
        this.mPosition = position;
        return this;
    }

    public Snackbar margin(int margin) {
        return this.margin(margin, margin, margin, margin);
    }

    public Snackbar margin(int marginLR, int marginTB) {
        return this.margin(marginLR, marginTB, marginLR, marginTB);
    }

    public Snackbar margin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.mMarginLeft = marginLeft;
        this.mMarginTop = marginTop;
        this.mMarginBottom = marginBottom;
        this.mMarginRight = marginRight;
        return this;
    }

    public Snackbar actionColor(int actionColor) {
        this.mActionColor = actionColor;
        return this;
    }

    public Snackbar actionColorResource(int resId) {
        return this.actionColor(this.getResources().getColor(resId));
    }

    public Snackbar dismissOnActionClicked(boolean shouldDismiss) {
        this.mShouldDismissOnActionClicked = shouldDismiss;
        return this;
    }

    public Snackbar actionListener(ActionClickListener listener) {
        this.mActionClickListener = listener;
        return this;
    }

    public Snackbar swipeListener(ActionSwipeListener listener) {
        this.mActionSwipeListener = listener;
        return this;
    }

    public Snackbar allowMultipleActionClicks(boolean shouldAllow) {
        this.mShouldAllowMultipleActionClicks = shouldAllow;
        return this;
    }

    public Snackbar eventListener(EventListener listener) {
        this.mEventListener = listener;
        return this;
    }

    public Snackbar animation(boolean withAnimation) {
        this.mAnimated = withAnimation;
        return this;
    }

    public Snackbar swipeToDismiss(boolean canSwipeToDismiss) {
        this.mCanSwipeToDismiss = canSwipeToDismiss;
        return this;
    }

    public Snackbar duration(SnackbarDuration duration) {
        this.mDuration = duration;
        return this;
    }

    public Snackbar duration(long duration) {
        this.mCustomDuration = duration > 0L ? duration : this.mCustomDuration;
        return this;
    }

    public Snackbar attachToAbsListView(AbsListView absListView) {
        absListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                Snackbar.this.dismiss();
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        return this;
    }

    public Snackbar attachToRecyclerView(View recyclerView) {
        try {
            Class.forName("android.support.v7.widget.RecyclerView");
            RecyclerUtil.setScrollListener(this, recyclerView);
        }
        catch (ClassNotFoundException ignored) {
            throw new IllegalArgumentException("RecyclerView not found. Did you add it to your dependencies?");
        }
        return this;
    }

    public Snackbar textTypeface(Typeface typeface) {
        this.mTextTypeface = typeface;
        return this;
    }

    public Snackbar actionLabelTypeface(Typeface typeface) {
        this.mActionTypeface = typeface;
        return this;
    }

    private static ViewGroup.MarginLayoutParams createMarginLayoutParams(ViewGroup viewGroup, int width, int height, SnackbarPosition position) {
        if (viewGroup instanceof FrameLayout) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
            params.gravity = position.getLayoutGravity();
            return params;
        }
        if (viewGroup instanceof RelativeLayout) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, height);
            if (position == SnackbarPosition.TOP) {
                params.addRule(10, -1);
            } else {
                params.addRule(12, -1);
            }
            return params;
        }
        if (viewGroup instanceof LinearLayout) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
            params.gravity = position.getLayoutGravity();
            return params;
        }
        throw new IllegalStateException("Requires FrameLayout or RelativeLayout for the parent of Snackbar");
    }

    static boolean shouldUsePhoneLayout(Context context) {
        if (context == null) {
            return true;
        }
        return context.getResources().getBoolean(R.bool.sb__is_phone);
    }

    private ViewGroup.MarginLayoutParams init(Context context, Activity targetActivity, ViewGroup parent, boolean usePhoneLayout) {
        ViewGroup.MarginLayoutParams params;
        SnackbarLayout layout2 = (SnackbarLayout)LayoutInflater.from((Context)context).inflate(R.layout.sb__template, (ViewGroup)this, true);
        Resources res = this.getResources();
        this.mColor = this.mColor != this.mUndefinedColor ? this.mColor : res.getColor(R.color.sb__background);
        this.mOffset = res.getDimensionPixelOffset(R.dimen.sb__offset);
        this.mUsePhoneLayout = usePhoneLayout;
        float scale = res.getDisplayMetrics().density;
        if (this.mUsePhoneLayout) {
            layout2.setMinimumHeight(Snackbar.dpToPx(this.mType.getMinHeight(), scale));
            layout2.setMaxHeight(Snackbar.dpToPx(this.mType.getMaxHeight(), scale));
            layout2.setBackgroundColor(this.mColor);
            params = Snackbar.createMarginLayoutParams(parent, -1, -2, this.mPosition);
        } else {
            this.mType = SnackbarType.SINGLE_LINE;
            layout2.setMinimumWidth(res.getDimensionPixelSize(R.dimen.sb__min_width));
            layout2.setMaxWidth(this.mMaxWidthPercentage == null ? res.getDimensionPixelSize(R.dimen.sb__max_width) : DisplayCompat.getWidthFromPercentage(targetActivity, this.mMaxWidthPercentage));
            layout2.setBackgroundResource(R.drawable.sb__bg);
            GradientDrawable bg = (GradientDrawable)layout2.getBackground();
            bg.setColor(this.mColor);
            params = Snackbar.createMarginLayoutParams(parent, -2, Snackbar.dpToPx(this.mType.getMaxHeight(), scale), this.mPosition);
        }
        if (this.mDrawable != this.mUndefinedDrawable) {
            Snackbar.setBackgroundDrawable((View)layout2, res.getDrawable(this.mDrawable));
        }
        this.snackbarText = (TextView)layout2.findViewById(R.id.sb__text);
        this.snackbarText.setText(this.mText);
        this.snackbarText.setTypeface(this.mTextTypeface);
        if (this.mTextColor != this.mUndefinedColor) {
            this.snackbarText.setTextColor(this.mTextColor);
        }
        this.snackbarText.setMaxLines(this.mType.getMaxLines());
        TextView snackbarAction = (TextView)layout2.findViewById(R.id.sb__action);
        if (!TextUtils.isEmpty((CharSequence)this.mActionLabel)) {
            this.requestLayout();
            snackbarAction.setText(this.mActionLabel);
            snackbarAction.setTypeface(this.mActionTypeface);
            if (this.mActionColor != this.mUndefinedColor) {
                snackbarAction.setTextColor(this.mActionColor);
            }
            snackbarAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!(Snackbar.this.mActionClickListener == null || Snackbar.this.mIsDismissing || Snackbar.this.mActionClicked && !Snackbar.this.mShouldAllowMultipleActionClicks)) {
                        Snackbar.this.mActionClickListener.onActionClicked(Snackbar.this);
                        Snackbar.this.mActionClicked = true;
                    }
                    if (Snackbar.this.mShouldDismissOnActionClicked) {
                        Snackbar.this.dismiss();
                    }
                }
            });
            snackbarAction.setMaxLines(this.mType.getMaxLines());
        } else {
            snackbarAction.setVisibility(8);
        }
        this.setClickable(true);
        if (this.mCanSwipeToDismiss && res.getBoolean(R.bool.sb__is_swipeable)) {
            this.setOnTouchListener(new SwipeDismissTouchListener((View)this, null, new SwipeDismissTouchListener.DismissCallbacks(){

                @Override
                public boolean canDismiss(Object token) {
                    return true;
                }

                @Override
                public void onDismiss(View view, Object token) {
                    if (view != null) {
                        if (Snackbar.this.mActionSwipeListener != null) {
                            Snackbar.this.mActionSwipeListener.onSwipeToDismiss();
                        }
                        Snackbar.this.dismiss(false);
                    }
                }

                @Override
                public void pauseTimer(boolean shouldPause) {
                    if (Snackbar.this.isIndefiniteDuration()) {
                        return;
                    }
                    if (shouldPause) {
                        Snackbar.this.removeCallbacks(Snackbar.this.mDismissRunnable);
                        Snackbar.this.mSnackbarFinish = System.currentTimeMillis();
                    } else {
                        Snackbar.this.mTimeRemaining = Snackbar.this.mTimeRemaining - (Snackbar.this.mSnackbarFinish - Snackbar.this.mSnackbarStart);
                        Snackbar.this.startTimer(Snackbar.this.mTimeRemaining);
                    }
                }
            }));
        }
        return params;
    }

    private void updateWindowInsets(Activity targetActivity, Rect outInsets) {
        outInsets.bottom = 0;
        outInsets.right = 0;
        outInsets.top = 0;
        outInsets.left = 0;
        if (targetActivity == null) {
            return;
        }
        ViewGroup decorView = (ViewGroup)targetActivity.getWindow().getDecorView();
        Display display = targetActivity.getWindowManager().getDefaultDisplay();
        boolean isTranslucent = this.isNavigationBarTranslucent(targetActivity);
        boolean isHidden = this.isNavigationBarHidden(decorView);
        Rect dispFrame = this.mDisplayFrame;
        Point realDispSize = this.mRealDisplaySize;
        Point dispSize = this.mDisplaySize;
        decorView.getWindowVisibleDisplayFrame(dispFrame);
        DisplayCompat.getRealSize(display, realDispSize);
        DisplayCompat.getSize(display, dispSize);
        if (dispSize.x < realDispSize.x) {
            if (isTranslucent || isHidden) {
                int navBarWidth = realDispSize.x - dispSize.x;
                int overlapWidth = realDispSize.x - dispFrame.right;
                outInsets.right = Math.max(Math.min(navBarWidth, overlapWidth), 0);
            }
        } else if (dispSize.y < realDispSize.y && (isTranslucent || isHidden)) {
            int navBarHeight = realDispSize.y - dispSize.y;
            int overlapHeight = realDispSize.y - dispFrame.bottom;
            outInsets.bottom = Math.max(Math.min(navBarHeight, overlapHeight), 0);
        }
    }

    private static int dpToPx(int dp, float scale) {
        return (int)((float)dp * scale + 0.5f);
    }

    public void showByReplace(Activity targetActivity) {
        this.mIsShowingByReplace = true;
        this.show(targetActivity);
    }

    public void showByReplace(ViewGroup parent) {
        this.mIsShowingByReplace = true;
        this.show(parent, Snackbar.shouldUsePhoneLayout(parent.getContext()));
    }

    public void showByReplace(ViewGroup parent, boolean usePhoneLayout) {
        this.mIsShowingByReplace = true;
        this.show(parent, usePhoneLayout);
    }

    public void show(Activity targetActivity) {
        ViewGroup root = (ViewGroup)targetActivity.findViewById(0x1020002);
        boolean usePhoneLayout = Snackbar.shouldUsePhoneLayout((Context)targetActivity);
        ViewGroup.MarginLayoutParams params = this.init((Context)targetActivity, targetActivity, root, usePhoneLayout);
        this.updateLayoutParamsMargins(targetActivity, params);
        this.showInternal(targetActivity, params, root);
    }

    public void show(ViewGroup parent) {
        this.show(parent, Snackbar.shouldUsePhoneLayout(parent.getContext()));
    }

    public void show(ViewGroup parent, boolean usePhoneLayout) {
        ViewGroup.MarginLayoutParams params = this.init(parent.getContext(), null, parent, usePhoneLayout);
        this.updateLayoutParamsMargins(null, params);
        this.showInternal(null, params, parent);
    }

    public Snackbar maxWidthPercentage(float maxWidthPercentage) {
        this.mMaxWidthPercentage = Float.valueOf(maxWidthPercentage);
        return this;
    }

    private void showInternal(Activity targetActivity, ViewGroup.MarginLayoutParams params, ViewGroup parent) {
        parent.removeView((View)this);
        parent.addView((View)this, (ViewGroup.LayoutParams)params);
        this.bringToFront();
        if (Build.VERSION.SDK_INT < 19) {
            parent.requestLayout();
            parent.invalidate();
        }
        this.mIsShowing = true;
        this.mTargetActivity = targetActivity;
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                Snackbar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                if (Snackbar.this.mEventListener != null) {
                    if (Snackbar.this.mIsShowingByReplace) {
                        Snackbar.this.mEventListener.onShowByReplace(Snackbar.this);
                    } else {
                        Snackbar.this.mEventListener.onShow(Snackbar.this);
                    }
                    if (!Snackbar.this.mAnimated) {
                        Snackbar.this.mEventListener.onShown(Snackbar.this);
                        Snackbar.this.mIsShowingByReplace = false;
                    }
                }
                return true;
            }
        });
        if (!this.mAnimated) {
            if (this.shouldStartTimer()) {
                this.startTimer();
            }
            return;
        }
        Animation slideIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)Snackbar.getInAnimationResource(this.mPosition));
        slideIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (Snackbar.this.mEventListener != null) {
                    Snackbar.this.mEventListener.onShown(Snackbar.this);
                    Snackbar.this.mIsShowingByReplace = false;
                }
                Snackbar.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Snackbar.this.mSnackbarStart = System.currentTimeMillis();
                        if (Snackbar.this.mTimeRemaining == -1L) {
                            Snackbar.this.mTimeRemaining = Snackbar.this.getDuration();
                        }
                        if (Snackbar.this.shouldStartTimer()) {
                            Snackbar.this.startTimer();
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(slideIn);
    }

    private boolean shouldStartTimer() {
        return !this.isIndefiniteDuration();
    }

    private boolean isIndefiniteDuration() {
        return this.getDuration() == SnackbarDuration.LENGTH_INDEFINITE.getDuration();
    }

    @TargetApi(value=16)
    private boolean isNavigationBarHidden(ViewGroup root) {
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        int viewFlags = root.getWindowSystemUiVisibility();
        return (viewFlags & 0x200) == 512;
    }

    private boolean isNavigationBarTranslucent(Activity targetActivity) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        int flags = targetActivity.getWindow().getAttributes().flags;
        return (flags & 0x8000000) != 0;
    }

    private void startTimer() {
        this.postDelayed(this.mDismissRunnable, this.getDuration());
    }

    private void startTimer(long duration) {
        this.postDelayed(this.mDismissRunnable, duration);
    }

    public void dismissByReplace() {
        this.mIsReplacePending = true;
        this.dismiss();
    }

    public void dismiss() {
        this.dismiss(this.mAnimated);
    }

    private void dismiss(boolean animate) {
        if (this.mIsDismissing) {
            return;
        }
        this.mIsDismissing = true;
        if (this.mEventListener != null && this.mIsShowing) {
            if (this.mIsReplacePending) {
                this.mEventListener.onDismissByReplace(this);
            } else {
                this.mEventListener.onDismiss(this);
            }
        }
        if (!animate) {
            this.finish();
            return;
        }
        Animation slideOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)Snackbar.getOutAnimationResource(this.mPosition));
        slideOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                Snackbar.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Snackbar.this.finish();
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(slideOut);
    }

    private void finish() {
        this.clearAnimation();
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null) {
            parent.removeView((View)this);
        }
        if (this.mEventListener != null && this.mIsShowing) {
            this.mEventListener.onDismissed(this);
        }
        this.mIsShowing = false;
        this.mIsReplacePending = false;
        this.mTargetActivity = null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDismissRunnable != null) {
            this.removeCallbacks(this.mDismissRunnable);
        }
        if (this.mRefreshLayoutParamsMarginsRunnable != null) {
            this.removeCallbacks(this.mRefreshLayoutParamsMarginsRunnable);
        }
    }

    void dispatchOnWindowSystemUiVisibilityChangedCompat(int visible) {
        this.onWindowSystemUiVisibilityChangedCompat(visible);
    }

    protected void onWindowSystemUiVisibilityChangedCompat(int visible) {
        if (this.mRefreshLayoutParamsMarginsRunnable != null) {
            this.post(this.mRefreshLayoutParamsMarginsRunnable);
        }
    }

    protected void refreshLayoutParamsMargins() {
        if (this.mIsDismissing) {
            return;
        }
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent == null) {
            return;
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        this.updateLayoutParamsMargins(this.mTargetActivity, params);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void updateLayoutParamsMargins(Activity targetActivity, ViewGroup.MarginLayoutParams params) {
        if (this.mUsePhoneLayout) {
            params.topMargin = this.mMarginTop;
            params.rightMargin = this.mMarginRight;
            params.leftMargin = this.mMarginLeft;
            params.bottomMargin = this.mMarginBottom;
        } else {
            params.topMargin = this.mMarginTop;
            params.rightMargin = this.mMarginRight;
            params.leftMargin = this.mMarginLeft + this.mOffset;
            params.bottomMargin = this.mMarginBottom + this.mOffset;
        }
        this.updateWindowInsets(targetActivity, this.mWindowInsets);
        params.rightMargin += this.mWindowInsets.right;
        params.bottomMargin += this.mWindowInsets.bottom;
    }

    public int getActionColor() {
        return this.mActionColor;
    }

    public CharSequence getActionLabel() {
        return this.mActionLabel;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getColor() {
        return this.mColor;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public long getDuration() {
        return this.mCustomDuration == -1L ? this.mDuration.getDuration() : this.mCustomDuration;
    }

    public SnackbarType getType() {
        return this.mType;
    }

    public boolean isActionClicked() {
        return this.mActionClicked;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public boolean isAnimated() {
        return this.mAnimated;
    }

    public boolean shouldDismissOnActionClicked() {
        return this.mShouldDismissOnActionClicked;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    public boolean isDimissing() {
        return this.mIsDismissing;
    }

    public boolean isDismissed() {
        return !this.mIsShowing;
    }

    public static int getInAnimationResource(SnackbarPosition snackbarPosition) {
        return snackbarPosition == SnackbarPosition.TOP ? R.anim.sb__top_in : R.anim.sb__bottom_in;
    }

    public static int getOutAnimationResource(SnackbarPosition snackbarPosition) {
        return snackbarPosition == SnackbarPosition.TOP ? R.anim.sb__top_out : R.anim.sb__bottom_out;
    }

    public static void setBackgroundDrawable(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable2);
        } else {
            view.setBackground(drawable2);
        }
    }

    public static enum SnackbarPosition {
        TOP(48),
        BOTTOM(80);

        private int layoutGravity;

        private SnackbarPosition(int layoutGravity) {
            this.layoutGravity = layoutGravity;
        }

        public int getLayoutGravity() {
            return this.layoutGravity;
        }
    }

    public static enum SnackbarDuration {
        LENGTH_SHORT(2000L),
        LENGTH_LONG(3500L),
        LENGTH_INDEFINITE(-1L);

        private long duration;

        private SnackbarDuration(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

