/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.ViewGroup;
import com.nispok.snackbar.Snackbar;
import java.lang.ref.WeakReference;

public class SnackbarManager {
    private static final String TAG = SnackbarManager.class.getSimpleName();
    private static final Handler MAIN_THREAD = new Handler(Looper.getMainLooper());
    private static WeakReference<Snackbar> snackbarReference;

    private SnackbarManager() {
    }

    public static void show(@NonNull Snackbar snackbar) {
        try {
            SnackbarManager.show(snackbar, (Activity)snackbar.getContext());
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)"Couldn't get Activity from the Snackbar's Context. Try calling #show(Snackbar, Activity) instead", (Throwable)e);
        }
    }

    public static void show(final @NonNull Snackbar snackbar, final @NonNull Activity activity) {
        MAIN_THREAD.post(new Runnable(){

            @Override
            public void run() {
                Snackbar currentSnackbar = SnackbarManager.getCurrentSnackbar();
                if (currentSnackbar != null) {
                    if (currentSnackbar.isShowing() && !currentSnackbar.isDimissing()) {
                        currentSnackbar.dismissAnimation(false);
                        currentSnackbar.dismissByReplace();
                        snackbarReference = new WeakReference<Snackbar>(snackbar);
                        snackbar.showAnimation(false);
                        snackbar.showByReplace(activity);
                        return;
                    }
                    currentSnackbar.dismiss();
                }
                snackbarReference = new WeakReference<Snackbar>(snackbar);
                snackbar.show(activity);
            }
        });
    }

    public static void show(@NonNull Snackbar snackbar, @NonNull ViewGroup parent) {
        SnackbarManager.show(snackbar, parent, Snackbar.shouldUsePhoneLayout(snackbar.getContext()));
    }

    public static void show(final @NonNull Snackbar snackbar, final @NonNull ViewGroup parent, final boolean usePhoneLayout) {
        MAIN_THREAD.post(new Runnable(){

            @Override
            public void run() {
                Snackbar currentSnackbar = SnackbarManager.getCurrentSnackbar();
                if (currentSnackbar != null) {
                    if (currentSnackbar.isShowing() && !currentSnackbar.isDimissing()) {
                        currentSnackbar.dismissAnimation(false);
                        currentSnackbar.dismissByReplace();
                        snackbarReference = new WeakReference<Snackbar>(snackbar);
                        snackbar.showAnimation(false);
                        snackbar.showByReplace(parent, usePhoneLayout);
                        return;
                    }
                    currentSnackbar.dismiss();
                }
                snackbarReference = new WeakReference<Snackbar>(snackbar);
                snackbar.show(parent, usePhoneLayout);
            }
        });
    }

    public static void dismiss() {
        final Snackbar currentSnackbar = SnackbarManager.getCurrentSnackbar();
        if (currentSnackbar != null) {
            MAIN_THREAD.post(new Runnable(){

                @Override
                public void run() {
                    currentSnackbar.dismiss();
                }
            });
        }
    }

    public static Snackbar getCurrentSnackbar() {
        if (snackbarReference != null) {
            return (Snackbar)((Object)snackbarReference.get());
        }
        return null;
    }
}

