/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar.layouts;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class SnackbarLayout
extends LinearLayout {
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxHeight = Integer.MAX_VALUE;

    public SnackbarLayout(Context context) {
        super(context);
    }

    public SnackbarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SnackbarLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mMaxWidth < width) {
            int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)mode);
        }
        if (this.mMaxHeight < (height = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
            int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)mode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
        this.requestLayout();
    }

    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
        this.requestLayout();
    }
}

