/*
 * Decompiled with CFR 0.152.
 */
package com.nispok.snackbar;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.util.Log;
import com.nispok.snackbar.Snackbar;

public class SnackbarManager {
    private static final String TAG = SnackbarManager.class.getSimpleName();
    private static Snackbar currentSnackbar;

    private SnackbarManager() {
    }

    public static void show(@NonNull Snackbar snackbar) {
        try {
            SnackbarManager.show(snackbar, (Activity)snackbar.getContext());
        }
        catch (ClassCastException e) {
            Log.e((String)TAG, (String)"Couldn't get Activity from the Snackbar's Context. Try calling #show(Snackbar, Activity) instead", (Throwable)e);
        }
    }

    public static void show(@NonNull Snackbar snackbar, @NonNull Activity activity) {
        if (currentSnackbar != null) {
            currentSnackbar.dismiss();
        }
        currentSnackbar = snackbar;
        currentSnackbar.show(activity);
    }
}

