/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.cloudyplugin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.nitorcreations.cloudyplugin.CustomizerResolver;
import com.nitorcreations.cloudyplugin.GroovyCustomizerResolver;
import com.nitorcreations.cloudyplugin.PackageInstallerBuilder;
import com.nitorcreations.cloudyplugin.TemplateCustomizer;
import com.nitorcreations.cloudyplugin.logging.config.MavenLoggingModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bouncycastle.util.io.Streams;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.enterprise.config.EnterpriseConfigurationModule;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class AbstractCloudyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter(property="developerId", required=false)
    private String developerId;
    @Parameter(property="securityConfiguration", required=false, defaultValue="~/.m2/settings-security.xml")
    private String securityConfiguration;
    @Parameter(defaultValue="default", property="instanceTag", required=true)
    protected String instanceTag;
    @Parameter(property="packages", required=false)
    protected String packages;
    @Parameter(property="preinstallscript", required=false)
    protected String preinstallscript;
    @Parameter(property="postinstallscript", required=false)
    protected String postinstallscript;
    @Parameter(property="properties", required=false)
    protected Map<String, String> properties;
    @Parameter(property="ensureRunning", required=false)
    protected boolean ensureRunning = false;
    @Component
    private SecDispatcher securityDispatcher;
    protected Developer currentDeveloper;
    protected String provider;
    protected String identity;
    protected String credential;
    protected String instanceId;
    protected ComputeServiceContext context;
    protected ComputeService compute;
    protected LoginCredentials login;
    protected Properties developerNodes = new Properties();
    protected File developerNodeFile;
    protected final CustomizerResolver resolver = new GroovyCustomizerResolver();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.securityConfiguration);
        }
        String user = System.getProperty("user.name", "");
        this.login = LoginCredentials.builder().user(user).build();
        if (this.developerId == null) {
            this.developerId = user;
        }
        if (this.developerId.isEmpty()) {
            throw new MojoExecutionException("Failed to get a developer id. Please define one with -DdeveloperId=foo");
        }
        Pattern matchAlias = Pattern.compile("(,|^)" + this.developerId + "(,|$)");
        for (Developer next : this.project.getDevelopers()) {
            String userAliases = next.getProperties().getProperty("useraliases", "");
            if (!this.developerId.equals(next.getId()) && !matchAlias.matcher(userAliases).find()) continue;
            this.currentDeveloper = next;
            break;
        }
        if (this.currentDeveloper == null) {
            throw new MojoExecutionException("No matching developer entry found. Add a developer entry with id " + this.developerId + " or the same as 'useralias' property for a developer");
        }
        this.getLog().info((CharSequence)("Using properties from developer " + this.currentDeveloper.getId()));
        Properties developerProperties = this.currentDeveloper.getProperties();
        this.provider = developerProperties.getProperty("provider");
        try {
            this.identity = this.securityDispatcher.decrypt(developerProperties.getProperty("identity"));
            this.credential = this.securityDispatcher.decrypt(developerProperties.getProperty("credential"));
        }
        catch (SecDispatcherException e) {
            e.printStackTrace();
        }
        if (this.provider == null || this.provider.isEmpty() || this.identity == null || this.identity.isEmpty() || this.credential == null || this.credential.isEmpty()) {
            throw new MojoExecutionException("Some provider information missing - provider: '" + this.provider + "' indetity: '" + this.identity + "' credential: '" + this.credential + "'");
        }
        this.compute = this.initComputeService();
        File pom = this.project.getFile();
        this.developerNodeFile = new File(pom.getParentFile(), "." + this.currentDeveloper.getId() + "-nodes");
        if (this.developerNodeFile.exists()) {
            try (FileInputStream in = new FileInputStream(this.developerNodeFile);){
                this.developerNodes.load(in);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read developer node data", (Exception)e);
            }
        }
        if (this.developerNodes.getProperty(this.instanceTag) != null) {
            this.instanceId = this.developerNodes.getProperty(this.instanceTag);
        }
        if (this.ensureRunning) {
            if (this.instanceId == null) {
                this.initNode();
            } else {
                NodeMetadata existingNode = this.compute.getNodeMetadata(this.instanceId);
                if (existingNode == null || existingNode.getStatus() == NodeMetadata.Status.TERMINATED) {
                    this.initNode();
                } else {
                    this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " with id " + this.instanceId + " found in local configuration."));
                    if (existingNode.getStatus() == NodeMetadata.Status.SUSPENDED) {
                        this.resumeNode();
                    } else if (existingNode.getStatus() != NodeMetadata.Status.RUNNING) {
                        throw new MojoExecutionException("Instance " + this.instanceId + " in erronous state: " + existingNode.getStatus());
                    }
                }
            }
        }
    }

    protected ComputeService initComputeService() throws MojoExecutionException {
        Properties overrideProperties = new Properties();
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.provider + ".defaultOverrides");){
            overrideProperties.load(in);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read provider default overrides", (Exception)e);
        }
        List<String> otherOverrides = this.resolveAllSettings("overrides");
        for (int i = otherOverrides.size() - 1; i >= 0; --i) {
            try (FileInputStream in = new FileInputStream(otherOverrides.get(i));){
                overrideProperties.load(in);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read overrides for instance tag " + this.instanceTag, (Exception)e);
            }
        }
        long scriptTimeout = TimeUnit.MILLISECONDS.convert(20L, TimeUnit.MINUTES);
        overrideProperties.setProperty("jclouds.compute.timeout.script-complete", scriptTimeout + "");
        ImmutableSet modules = ImmutableSet.of((Object)new JschSshClientModule(), (Object)((Object)new MavenLoggingModule(this.getLog())), (Object)new EnterpriseConfigurationModule());
        ContextBuilder builder = ContextBuilder.newBuilder((String)this.provider).credentials(this.identity, this.credential).modules((Iterable)modules).overrides(overrideProperties);
        this.context = (ComputeServiceContext)builder.buildView(ComputeServiceContext.class);
        return this.context.getComputeService();
    }

    protected List<String> resolveAllSettings(String name) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.currentDeveloper.getProperties().getProperty(this.instanceTag + "-" + name) != null) {
            ret.add(this.currentDeveloper.getProperties().getProperty(this.instanceTag + "-" + name));
        }
        if (this.currentDeveloper.getProperties().getProperty(this.provider + "-" + name) != null) {
            ret.add(this.currentDeveloper.getProperties().getProperty(this.provider + "-" + name));
        }
        if (this.currentDeveloper.getProperties().getProperty(name) != null) {
            ret.add(this.currentDeveloper.getProperties().getProperty(name));
        }
        try {
            Field field = ((Object)((Object)this)).getClass().getField(name);
            Object value = field.get((Object)this);
            if (value != null) {
                ret.add(value.toString());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (this.properties != null && this.properties.get(this.instanceTag + "-" + name) != null) {
            ret.add(this.properties.get(this.instanceTag + "-" + name));
        }
        if (this.properties != null && this.properties.get(this.provider + "-" + name) != null) {
            ret.add(this.properties.get(this.provider + "-" + name));
        }
        if (this.properties != null && this.properties.get(name) != null) {
            ret.add(this.properties.get(name));
        }
        return ret;
    }

    protected String resolveSetting(String name, String defaultValue) {
        List<String> ret = this.resolveAllSettings(name);
        if (ret.size() != 0) {
            return ret.get(0);
        }
        return defaultValue;
    }

    public static String getResource(String resource) throws IOException {
        if (resource.startsWith("classpath:")) {
            String res = resource.substring(10);
            if (!res.startsWith("/")) {
                res = "/" + res;
            }
            try (InputStream in = AbstractCloudyMojo.class.getResourceAsStream(res);){
                if (in == null) {
                    throw new IOException("Classpath resource " + resource + " not found");
                }
                String string = new String(Streams.readAll((InputStream)in), Charset.forName("UTF-8"));
                return string;
            }
        }
        return Files.toString((File)new File(resource), (Charset)Charset.forName("UTF-8"));
    }

    protected boolean waitForStatus(String nodeId, NodeMetadata.Status status, long timeout) {
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end) {
            NodeMetadata state = this.compute.getNodeMetadata(nodeId);
            if ((state != null || status != NodeMetadata.Status.TERMINATED) && (state == null || state.getStatus() != status)) continue;
            return true;
        }
        return false;
    }

    protected void runConfiguredScript(String parameterName) throws MojoExecutionException {
        String scriptResource = this.resolveSetting(parameterName, null);
        if (scriptResource != null && !scriptResource.isEmpty()) {
            try {
                String content = AbstractCloudyMojo.getResource(scriptResource);
                this.compute.runScriptOnNode(this.instanceId, Statements.exec((String)content), (RunScriptOptions)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)this.login).runAsRoot(true).wrapInInitScript(false));
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Failed to run " + parameterName, e);
            }
        }
    }

    protected void installPackages(String packageList) {
        if (packageList == null || packageList.isEmpty()) {
            return;
        }
        NodeMetadata node = this.compute.getNodeMetadata(this.instanceId);
        PackageInstallerBuilder pkg = PackageInstallerBuilder.create(node.getOperatingSystem());
        this.getLog().info((CharSequence)("Installing packages " + packageList));
        for (String next : packageList.split(",")) {
            pkg.addPackage(next);
        }
        this.compute.runScriptOnNode(this.instanceId, Statements.exec((String)pkg.build()), (RunScriptOptions)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)this.login).runAsRoot(true).wrapInInitScript(false));
    }

    protected String prettyPrint(String nodeInfo) {
        StringBuilder ret = new StringBuilder();
        int level = 0;
        for (String next : nodeInfo.split(",\\s")) {
            for (int i = 0; i < level; ++i) {
                ret.append("   ");
            }
            int levelUps = this.occurrances(next, '{');
            int levelDowns = this.occurrances(next, '}');
            level = level + levelUps - levelDowns;
            ret.append(next).append("\n");
        }
        return ret.toString();
    }

    private int occurrances(String next, char find) {
        int ret = 0;
        for (int i = 0; i < next.length(); ++i) {
            if (next.charAt(i) != find) continue;
            ++ret;
        }
        return ret;
    }

    protected void initNode() throws MojoExecutionException {
        String groupName = this.project.getGroupId().replaceAll("[^a-zA-Z\\-]", "-") + "-" + this.project.getArtifactId().replaceAll("[^a-zA-Z\\-]", "-");
        if (this.instanceId != null) {
            NodeMetadata existingNode = this.compute.getNodeMetadata(this.instanceId);
            if (existingNode != null && existingNode.getStatus() != NodeMetadata.Status.TERMINATED) {
                throw new MojoExecutionException("Developernode with tag " + this.instanceTag + " already exists with id: " + this.instanceId);
            }
            this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " with id " + this.instanceId + " found in local configuration but not active in the backend service"));
        }
        TemplateCustomizer customizer = this.resolver.resolveCustomizer(this.instanceTag, this.provider, this.currentDeveloper.getProperties());
        TemplateBuilder templateBuilder = this.compute.templateBuilder();
        customizer.customize(templateBuilder);
        try (FileOutputStream out = new FileOutputStream(this.developerNodeFile);){
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.compute.createNodesInGroup(groupName, 1, templateBuilder.build()));
            this.instanceId = node.getId();
            this.developerNodes.put(this.instanceTag, this.instanceId);
            this.developerNodes.store(out, null);
        }
        catch (RunNodesException e) {
            throw new MojoExecutionException("Failed to create node", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store developer node details", (Exception)e);
        }
        this.runConfiguredScript("preinstallscript");
        this.installPackages(this.resolveSetting("packages", null));
        this.runConfiguredScript("postinstallscript");
    }

    protected NodeMetadata resumeNode() throws MojoExecutionException {
        try {
            this.compute.resumeNode(this.instanceId);
        }
        catch (Throwable e) {
            this.getLog().info((CharSequence)("Error in resuming node: " + e.getMessage()));
            this.getLog().debug(e);
        }
        NodeMetadata nodeMetadata = this.compute.getNodeMetadata(this.instanceId);
        if (nodeMetadata == null || nodeMetadata.getStatus() != NodeMetadata.Status.RUNNING) {
            throw new MojoExecutionException("Failed to resume node " + this.instanceId);
        }
        return nodeMetadata;
    }
}

