/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.cloudyplugin;

import com.nitorcreations.cloudyplugin.AbstractCloudyMojo;
import com.nitorcreations.cloudyplugin.CustomizerResolver;
import com.nitorcreations.cloudyplugin.TemplateCustomizer;
import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;

@Named
public class GroovyCustomizerResolver
implements CustomizerResolver {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TemplateCustomizer resolveCustomizer(String instanceTag, String provider, Properties developerProperties) throws MojoExecutionException {
        String customizerResource = "classpath:" + provider + "-customizer.groovy";
        if (developerProperties.getProperty(instanceTag + "-customizer") != null) {
            customizerResource = developerProperties.getProperty(instanceTag + "-customizer");
        } else if (developerProperties.getProperty(provider + "-customizer") != null) {
            customizerResource = developerProperties.getProperty(provider + "-customizer");
        }
        try (GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());){
            Class customizerClass = loader.parseClass(AbstractCloudyMojo.getResource(customizerResource));
            TemplateCustomizer templateCustomizer = (TemplateCustomizer)customizerClass.newInstance();
            return templateCustomizer;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Failed to run templage customizer script", e);
        }
    }
}

