/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.cloudyplugin;

import java.util.LinkedHashSet;
import org.codehaus.plexus.util.StringUtils;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.predicates.OperatingSystemPredicates;

public abstract class PackageInstallerBuilder {
    protected final String mgrCommand;
    protected final LinkedHashSet<String> packages = new LinkedHashSet();

    protected PackageInstallerBuilder(String mgrCommand) {
        this.mgrCommand = mgrCommand;
    }

    public static PackageInstallerBuilder create(OperatingSystem os) {
        if (OperatingSystemPredicates.supportsApt().apply((Object)os)) {
            return new AptPackageInstaller();
        }
        if (OperatingSystemPredicates.supportsYum().apply((Object)os)) {
            return new YumPackageInstaller();
        }
        if (OperatingSystemPredicates.supportsZypper().apply((Object)os)) {
            return new ZypperPackageInstaller();
        }
        throw new IllegalArgumentException("don't know how to handle" + os.toString());
    }

    public String build() {
        return this.command();
    }

    public PackageInstallerBuilder addPackage(String pkg) {
        this.packages.add(pkg);
        return this;
    }

    protected String command() {
        return this.mgrCommand + StringUtils.join(this.packages.iterator(), (String)" ");
    }

    public static class ZypperPackageInstaller
    extends PackageInstallerBuilder {
        protected ZypperPackageInstaller() {
            super("zypper -n in ");
        }
    }

    public static class YumPackageInstaller
    extends PackageInstallerBuilder {
        protected YumPackageInstaller() {
            super("yum install -y ");
        }
    }

    public static class AptPackageInstaller
    extends PackageInstallerBuilder {
        protected AptPackageInstaller() {
            super("apt-get install -y ");
        }
    }
}

