/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.cloudyplugin;

import com.nitorcreations.cloudyplugin.AbstractCloudyMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.jclouds.compute.domain.NodeMetadata;

@Mojo(name="safenodeinfo", aggregator=true)
public class SafeNodeInfoMojo
extends AbstractCloudyMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        NodeMetadata nodeMetadata;
        super.execute();
        if (this.instanceId == null) {
            this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " not found, initializing."));
            this.initNode();
        }
        if ((nodeMetadata = this.compute.getNodeMetadata(this.instanceId)) == null || nodeMetadata.getStatus() == NodeMetadata.Status.TERMINATED) {
            throw new MojoExecutionException("Developernode with tag " + this.instanceTag + " does not exists with id: " + this.instanceId);
        }
        this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " with id " + this.instanceId + " found in local configuration."));
        if (nodeMetadata.getStatus() == NodeMetadata.Status.SUSPENDED) {
            this.getLog().info((CharSequence)"Node is suspended, resuming.");
            nodeMetadata = this.resumeNode();
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)this.prettyPrint(nodeMetadata.toString()));
        } else {
            System.out.print(this.prettyPrint(nodeMetadata.toString()));
        }
    }
}

