/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.cloudyplugin;

import com.nitorcreations.cloudyplugin.AbstractCloudyMojo;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.jclouds.compute.domain.NodeMetadata;

@Mojo(name="terminate", aggregator=true)
public class TerminateMojo
extends AbstractCloudyMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.instanceId != null) {
            NodeMetadata existingNode = this.compute.getNodeMetadata(this.instanceId);
            if (existingNode == null || existingNode.getStatus() == NodeMetadata.Status.TERMINATED) {
                this.removeNode();
                throw new MojoExecutionException("Developernode with tag " + this.instanceTag + " does not exists with id: " + this.instanceId);
            }
        } else {
            this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " not found in local configuration."));
            return;
        }
        this.getLog().info((CharSequence)("Existing node with tag " + this.instanceTag + " with id " + this.instanceId + " found in local configuration."));
        try {
            this.compute.destroyNode(this.instanceId);
        }
        catch (Throwable e) {
            this.getLog().info((CharSequence)("Error in deleting node: " + e.getMessage()));
            this.getLog().debug(e);
        }
        if (!this.waitForStatus(this.instanceId, NodeMetadata.Status.TERMINATED, 180000L)) {
            throw new MojoExecutionException("Failed to terminate node " + this.instanceId);
        }
        this.removeNode();
    }

    private void removeNode() throws MojoExecutionException {
        try (FileOutputStream out = new FileOutputStream(this.developerNodeFile);){
            this.developerNodes.remove(this.instanceTag);
            this.developerNodes.store(out, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store developer node details", (Exception)e);
        }
    }
}

