/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.rules;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipTestMethodsAfterFirstFailureRule
implements TestRule {
    static final ConcurrentMap<Class<?>, String> failures = new ConcurrentHashMap();
    final Class<?> testClass;

    public SkipTestMethodsAfterFirstFailureRule(Class<?> testClass) {
        this.testClass = testClass;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String failedTestName = (String)failures.get(SkipTestMethodsAfterFirstFailureRule.this.testClass);
                if (failedTestName != null) {
                    Assume.assumeTrue((String)("Previous test '" + failedTestName + "' failed"), (boolean)false);
                }
                boolean ok = false;
                try {
                    base.evaluate();
                    ok = true;
                }
                finally {
                    if (!ok) {
                        failures.put(SkipTestMethodsAfterFirstFailureRule.this.testClass, description.getDisplayName());
                    }
                }
            }
        };
    }
}

