/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runner;

import com.nitorcreations.junit.runner.XmlJUnitFormatter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneJUnitRunner {
    static final PrintStream out = System.out;

    public void main(String[] args) {
        Result[] results = this.runTests(args);
        List<Failure> failures = this.collectFailures(results);
        if (failures.isEmpty()) {
            return;
        }
        for (Failure f : failures) {
            out.println(f.toString());
        }
        throw new RuntimeException("Tests Failed");
    }

    public Result[] runTests(String ... args) {
        Class<?>[][] classSets = this.parseClassSets(args);
        return this.runTests(classSets);
    }

    public List<Failure> collectFailures(Result[] results) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (Result result : results) {
            if (result.wasSuccessful()) continue;
            failures.addAll(result.getFailures());
        }
        return failures;
    }

    private Class<?>[][] parseClassSets(String ... args) {
        HashSet<String> seenClassNames = new HashSet<String>();
        Class[][] classSets = new Class[args.length][];
        for (int i = 0; i < args.length; ++i) {
            String[] classNames = args[i].split(",");
            classSets[i] = new Class[classNames.length];
            for (int j = 0; j < classNames.length; ++j) {
                String className = classNames[j].trim();
                if (!seenClassNames.add(className)) {
                    throw new RuntimeException("Duplicate class name specified: " + className);
                }
                try {
                    classSets[i][j] = Class.forName(className);
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Class " + className + " not available: " + t);
                }
            }
        }
        return classSets;
    }

    private Result[] runTests(Class<?>[][] classSets) {
        Result[] results = new Result[classSets.length];
        Thread[] runners = this.createAndStartTestThreads(classSets, results);
        this.waitForTestThreadsToFinish(runners);
        return results;
    }

    private Thread[] createAndStartTestThreads(final Class<?>[][] classSets, final Result[] results) {
        Thread[] runners = new Thread[classSets.length];
        for (int i = 0; i < classSets.length; ++i) {
            final int testNum = i;
            runners[i] = new Thread("TestRunner-" + testNum){

                public void run() {
                    JUnitCore junit = StandaloneJUnitRunner.createJunit(testNum);
                    results[testNum] = junit.run(classSets[testNum]);
                }
            };
            runners[i].start();
        }
        return runners;
    }

    static JUnitCore createJunit(final int testNum) {
        JUnitCore junit = new JUnitCore();
        junit.addListener(new RunListener(){

            public void testStarted(Description description) throws Exception {
                out.printf("Thread-%d: Running: %s%n", testNum, description.getDisplayName());
            }

            public void testFinished(Description description) throws Exception {
                out.printf("Thread-%d: Finished: %s%n", testNum, description.getDisplayName());
            }
        });
        junit.addListener((RunListener)new XmlJUnitFormatter(testNum));
        return junit;
    }

    private void waitForTestThreadsToFinish(Thread[] runners) {
        for (Thread runner : runners) {
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

