/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ThreadLocalStdOutErrCapturer {
    public static final ThreadLocal<CaptureStreams> stdoutCapture = new CaptureStreamThreadLocal();
    public static final ThreadLocal<CaptureStreams> stderrCapture = new CaptureStreamThreadLocal();

    public static void captureStdOutAndErrStreams() {
        System.setOut(new RedirectingPrintStream(stdoutCapture));
        System.setErr(new RedirectingPrintStream(stderrCapture));
    }

    static class FailingOutputStream
    extends OutputStream {
        FailingOutputStream() {
        }

        public void write(int b) throws IOException {
            throw new IllegalStateException("RedirectingPrintStream did not redirect this method");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RedirectingPrintStream
    extends PrintStream {
        private ThreadLocal<CaptureStreams> capture;

        @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="PrintStream encoding is never used")
        public RedirectingPrintStream(ThreadLocal<CaptureStreams> capture) {
            super(new FailingOutputStream());
            this.capture = capture;
        }

        @Override
        public void println() {
            this.capture.get().writer.println();
        }

        @Override
        public void println(String x) {
            this.capture.get().writer.println(x);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.capture.get().writer.write(buf, off, len);
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.capture.get().writer.printf(format, args);
        }
    }

    public static class CaptureStreams {
        final ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
        final PrintStream writer;

        CaptureStreams() {
            try {
                this.writer = new PrintStream((OutputStream)this.bytes, true, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            try {
                return this.bytes.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CaptureStreamThreadLocal
    extends InheritableThreadLocal<CaptureStreams> {
        CaptureStreamThreadLocal() {
        }

        @Override
        protected CaptureStreams initialValue() {
            return new CaptureStreams();
        }
    }
}

