/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runner;

import com.nitorcreations.junit.runner.ThreadLocalStdOutErrCapturer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class XmlJUnitFormatter
extends RunListener {
    private final List<TestStatus> results = new ArrayList<TestStatus>();
    private final int threadNumber;
    private String testName;
    private PrintWriter xml;
    private Status status;
    private String failureTrace;
    private long testStartTime;
    private int errorCount;
    private int failureCount;
    private int skippedCount;
    private static final String outputDir = System.getProperty("output.dir", ".") + File.separator;

    public XmlJUnitFormatter(int threadNumber) {
        this.threadNumber = threadNumber;
    }

    public void testRunStarted(Description description) throws Exception {
        if ((description.getClassName() == null || description.getClassName().equals("null")) && !description.getChildren().isEmpty()) {
            this.testName = System.getProperty("test.name", "");
            if (!this.testName.isEmpty()) {
                this.testName = this.testName + '-';
            }
            this.testName = this.testName + ((Description)description.getChildren().get(0)).getClassName();
        } else {
            this.testName = System.getProperty("test.name", description.getClassName());
        }
        String name = "TEST-" + this.testName + "-" + this.threadNumber + ".xml";
        this.xml = new PrintWriter(outputDir + name, "UTF-8");
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="JUnit runner calls testRunStarted before this method")
    public void testRunFinished(Result result) throws Exception {
        this.xml.printf("<?xml version=\"1.1\" encoding=\"UTF-8\"?>%n", new Object[0]);
        this.xml.printf("<testsuite name=\"%s\" time=\"%f\" tests=\"%d\" errors=\"%d\" skipped=\"%d\" failures=\"%d\">%n", this.testName, (double)result.getRunTime() / 1000.0, this.results.size(), this.errorCount, this.skippedCount, this.failureCount);
        for (TestStatus test : this.results) {
            String ignoreAttr = "";
            if (test.status == Status.ignored) {
                ignoreAttr = " ignored=\"true\"";
            }
            this.xml.printf(" <testcase name=\"%s\" classname=\"%s\" time=\"%f\"%s>", test.name, test.classname, (double)test.runTime / 1000.0, ignoreAttr);
            this.printIfPresent("system-out", test.stdout);
            this.printIfPresent("system-err", test.stderr);
            this.printIfPresent(test.status.traceElement, test.trace);
            this.xml.printf("</testcase>%n", new Object[0]);
        }
        this.xml.print("</testsuite>");
        this.xml.close();
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="JUnit runner calls testRunStarted before this method")
    private void printIfPresent(String element, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        this.xml.printf("%n  <%s>%s</%s>", element, XmlJUnitFormatter.xmlEscape(text), element);
    }

    private static String xmlEscape(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 128);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '\u0000') {
                sb.append("(0)");
                continue;
            }
            if (ch >= '\u0001' && ch <= '\b' || ch == '\u000b' || ch == '\f' || ch >= '\u000e' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u0084' || ch >= '\u0086' && ch <= '\u009f') {
                sb.append("&#x");
                sb.append(Integer.toHexString(ch));
                sb.append(';');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public void testStarted(Description description) throws Exception {
        this.status = Status.success;
        this.failureTrace = null;
        this.testStartTime = System.currentTimeMillis();
    }

    public void testFinished(Description description) throws Exception {
        this.addResult(description);
    }

    public void testAssumptionFailure(Failure failure) {
        this.status = Status.assumptionFailure;
        this.failureTrace = failure.getTrace();
        ++this.skippedCount;
    }

    public void testIgnored(Description description) throws Exception {
        this.failureTrace = "ignored";
        this.status = Status.ignored;
        ++this.skippedCount;
        this.addResult(description);
    }

    public void testFailure(Failure failure) {
        if (this.status == Status.success) {
            if (failure.getException() instanceof AssertionError) {
                this.status = Status.failed;
                ++this.failureCount;
            } else {
                this.status = Status.error;
                ++this.errorCount;
            }
            this.failureTrace = failure.getTrace();
        }
    }

    private void addResult(Description description) {
        long duration;
        if (this.testStartTime > 0L) {
            duration = System.currentTimeMillis() - this.testStartTime;
            this.testStartTime = 0L;
        } else {
            duration = 0L;
        }
        System.out.flush();
        System.err.flush();
        ThreadLocalStdOutErrCapturer.CaptureStreams outCapture = ThreadLocalStdOutErrCapturer.stdoutCapture.get();
        ThreadLocalStdOutErrCapturer.CaptureStreams errCapture = ThreadLocalStdOutErrCapturer.stderrCapture.get();
        this.results.add(new TestStatus(description, this.status, this.failureTrace, outCapture.toString(), errCapture.toString(), duration));
        outCapture.bytes.reset();
        errCapture.bytes.reset();
    }

    static {
        File dir = new File(outputDir);
        if (!dir.mkdirs() && !dir.exists()) {
            throw new RuntimeException("Failed to create output directory " + outputDir);
        }
        ThreadLocalStdOutErrCapturer.captureStdOutAndErrStreams();
    }

    static class TestStatus {
        public final String name;
        public final String classname;
        public final String stderr;
        public final String stdout;
        public final Status status;
        public final String trace;
        public final long runTime;

        public TestStatus(Description description, Status status, String trace, String stdout, String stderr, long runTime) {
            this.status = status;
            this.trace = trace;
            this.stdout = stdout;
            this.stderr = stderr;
            this.runTime = runTime;
            this.name = description.getMethodName();
            this.classname = description.getClassName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        success(null),
        ignored("skipped"),
        error("error"),
        failed("failure"),
        assumptionFailure("skipped");

        public final String traceElement;

        private Status(String traceElement) {
            this.traceElement = traceElement;
        }
    }
}

