/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedRunner
extends ParentRunner<Object> {
    private final List<Object> children = new ArrayList<Object>();
    private final NestedClassRunner delegatedRunner;
    private final NestedRunner parentRunner;

    public NestedRunner(Class<?> testClass) throws InitializationError {
        this(testClass, null);
    }

    public NestedRunner(Class<?> testClass, NestedRunner parentRunner) throws InitializationError {
        super(testClass);
        this.parentRunner = parentRunner;
        this.delegatedRunner = new NestedClassRunner(testClass);
        this.children.addAll(this.delegatedRunner.giveMeTheDamnChildren());
        this.addToChildrenAllNestedClassesWithTestsAndTestMethods(testClass);
    }

    private void addToChildrenAllNestedClassesWithTestsAndTestMethods(Class<?> testClass) throws InitializationError {
        for (Class<?> child : testClass.getDeclaredClasses()) {
            if (!this.containsTests(child)) continue;
            this.children.add((Object)new NestedRunner(child, this));
        }
    }

    private boolean containsTests(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return this.childrenContainTests(clazz);
    }

    public boolean childrenContainTests(Class<?> clazz) {
        for (Class<?> klazz : clazz.getDeclaredClasses()) {
            if (!this.containsTests(klazz)) continue;
            return true;
        }
        return false;
    }

    protected List<Object> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.getTestClass().getJavaClass().getSimpleName();
    }

    protected Description describeChild(Object child) {
        if (child instanceof Runner) {
            return ((Runner)child).getDescription();
        }
        return this.delegatedRunner.callTheProtectedDescribeChild((FrameworkMethod)child);
    }

    protected void runChild(Object child, RunNotifier notifier) {
        if (child instanceof Runner) {
            ((Runner)child).run(notifier);
        } else {
            this.delegatedRunner.callThePrivateRunChild((FrameworkMethod)child, notifier);
        }
    }

    private Object constructTestClass() throws Exception {
        if (this.getTestClass().getOnlyConstructor().getParameterTypes().length == 1 && this.parentRunner != null) {
            Object parent = this.parentRunner.constructTestClass();
            Object newInstance = this.getTestClass().getOnlyConstructor().newInstance(parent);
            this.delegatedRunner.currentTestObject = newInstance;
            return newInstance;
        }
        Object newInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        this.delegatedRunner.currentTestObject = newInstance;
        return newInstance;
    }

    public List<FrameworkMethod> getBefores() {
        ArrayList<FrameworkMethod> befores = new ArrayList<FrameworkMethod>();
        befores.addAll(this.getTestClass().getAnnotatedMethods(Before.class));
        return befores;
    }

    public List<FrameworkMethod> getAfters() {
        ArrayList<FrameworkMethod> afters = new ArrayList<FrameworkMethod>();
        afters.addAll(this.getTestClass().getAnnotatedMethods(After.class));
        return afters;
    }

    private Statement withParentBefores(Statement statement) {
        if (this.parentRunner != null) {
            return this.parentRunner.withParentBefores((Statement)new RunBefores(statement, this.getBefores(), this.delegatedRunner.currentTestObject));
        }
        return new RunBefores(statement, this.getBefores(), this.delegatedRunner.currentTestObject);
    }

    private Statement withParentAfters(Statement statement) {
        if (this.parentRunner != null) {
            return new RunAfters(this.parentRunner.withParentAfters(statement), this.getAfters(), this.delegatedRunner.currentTestObject);
        }
        return new RunAfters(statement, this.getAfters(), this.delegatedRunner.currentTestObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NestedClassRunner
    extends BlockJUnit4ClassRunner {
        private Object currentTestObject;

        public NestedClassRunner(Class<?> childClass) throws InitializationError {
            super(childClass);
        }

        public void callThePrivateRunChild(FrameworkMethod child, RunNotifier notifier) {
            this.runChild(child, notifier);
        }

        public Description callTheProtectedDescribeChild(FrameworkMethod child) {
            return this.describeChild(child);
        }

        public Collection<? extends Object> giveMeTheDamnChildren() {
            return super.getChildren();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            this.validateNonStaticInnerClassWithDefaultConstructor(errors);
        }

        private void validateNonStaticInnerClassWithDefaultConstructor(List<Throwable> errors) {
            try {
                this.getTestClass().getJavaClass().getConstructor(NestedRunner.this.getTestClass().getJavaClass());
            }
            catch (NoSuchMethodException e) {
                String gripe = "Nested test classes should be non-static and have a public zero-argument constructor";
                errors.add(new Exception(gripe));
            }
        }

        protected Object createTest() throws Exception {
            return NestedRunner.this.constructTestClass();
        }

        protected Statement methodBlock(FrameworkMethod method) {
            Statement statement = super.methodBlock(method);
            if (statement instanceof Fail) {
                return statement;
            }
            statement = NestedRunner.this.withParentBefores(statement);
            statement = NestedRunner.this.withParentAfters(statement);
            return statement;
        }

        protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
            return new RunBefores(statement, new ArrayList(), target);
        }

        protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
            return new RunAfters(statement, new ArrayList(), target);
        }

        protected void collectInitializationErrors(List<Throwable> errors) {
            this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
            this.validatePublicVoidNoArgMethods(AfterClass.class, true, errors);
        }
    }
}

