/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLoaderInjector {
    private static final Method DEFINE_CLASS_METHOD = ClassLoaderInjector.getDefineClassMethod();

    ClassLoaderInjector() {
    }

    private static Method getDefineClassMethod() {
        try {
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            return defineClassMethod;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> injectClass(String name, byte[] clazzBytes) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ClassLoaderInjector.injectClass(name, clazzBytes, cl);
    }

    public static Class<?> injectClass(String name, byte[] clazzBytes, ClassLoader classLoader) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, name, clazzBytes, 0, clazzBytes.length);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

