/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import com.nitorcreations.junit.runners.parameterized.ClassLoaderInjector;
import com.nitorcreations.junit.runners.parameterized.ParameterizationStrategy;
import com.nitorcreations.junit.runners.parameterized.ParameterizationStrategyNotAvailableException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.powermock.core.classloader.annotations.PowerMockIgnore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowermockParameterizationStrategy
implements ParameterizationStrategy {
    private static final String PACKAGE_FOR_POWERMOCK_AVOIDANCE_RAW = "com/nitorcreations/nomocks";
    private static final String POWERMOCK_HELPER_PREFIX = "PowerMockHelper";
    private static final String FIELD_TEST_CLASS_BYTE_ARR = "testClassByteArr";
    private static final String FIELD_CONSTRUCTOR_ARGS = "constructorArgs";
    private static final String CLASSPATH_ADJUSTER_CLASS_INTERNALNAME = "org/powermock/core/classloader/ClassPathAdjuster";
    private static final String USE_CLASSPATH_ADJUSTER_CLASS_DESCRIPTOR = "Lorg/powermock/core/classloader/annotations/UseClassPathAdjuster;";
    private static final String CLASSPATH_ADJUSTER_CLASSNAME = "org/powermock/core/classloader/ClassPathAdjuster".replace('/', '.');
    private String nameRaw;
    private String powerMockHelperClassRaw;

    private static String getPowerMockHelperClassRaw(String nameRaw) {
        String powerMockHelperClassRaw = "com/nitorcreations/nomocks/PowerMockHelper_" + nameRaw.replace('/', '_').replace('$', '_');
        return powerMockHelperClassRaw;
    }

    public PowermockParameterizationStrategy() {
        try {
            Class.forName(CLASSPATH_ADJUSTER_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            throw new ParameterizationStrategyNotAvailableException("Your version of PowerMock is too old - version 1.5.5 or later required");
        }
    }

    @Override
    public void classCreationInProgress(String nameRaw, ClassVisitor cw) {
        this.nameRaw = nameRaw;
        this.powerMockHelperClassRaw = PowermockParameterizationStrategy.getPowerMockHelperClassRaw(nameRaw);
        AnnotationVisitor av0 = cw.visitAnnotation(USE_CLASSPATH_ADJUSTER_CLASS_DESCRIPTOR, true);
        av0.visit("value", (Object)Type.getObjectType((String)this.powerMockHelperClassRaw));
        av0.visitEnd();
        AnnotationVisitor av1 = cw.visitAnnotation(Type.getType(PowerMockIgnore.class).getDescriptor(), true);
        AnnotationVisitor av2 = av1.visitArray("value");
        av2.visit(null, (Object)(PACKAGE_FOR_POWERMOCK_AVOIDANCE_RAW.replace('/', '.') + ".*"));
        av2.visitEnd();
        av1.visitEnd();
    }

    @Override
    public void loadConstructorArgs(GeneratorAdapter mv) {
        mv.visitFieldInsn(178, this.powerMockHelperClassRaw, FIELD_CONSTRUCTOR_ARGS, "[Ljava/lang/Object;");
    }

    @Override
    public void classConstructed(Class<?> clazz, byte[] clazzBytes, Object[] constructorArgs) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, this.powerMockHelperClassRaw, null, "java/lang/Object", new String[]{CLASSPATH_ADJUSTER_CLASS_INTERNALNAME});
        cw.visitField(9, FIELD_TEST_CLASS_BYTE_ARR, "[B", null, null).visitEnd();
        cw.visitField(9, FIELD_CONSTRUCTOR_ARGS, "[Ljava/lang/Object;", null, null).visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "adjustClassPath", "(Ljavassist/ClassPool;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, "javassist/ByteArrayClassPath");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Type.getObjectType((String)this.nameRaw).getClassName());
        mv.visitFieldInsn(178, this.powerMockHelperClassRaw, FIELD_TEST_CLASS_BYTE_ARR, "[B");
        mv.visitMethodInsn(183, "javassist/ByteArrayClassPath", "<init>", "(Ljava/lang/String;[B)V");
        mv.visitMethodInsn(182, "javassist/ClassPool", "appendClassPath", "(Ljavassist/ClassPath;)Ljavassist/ClassPath;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(5, 2);
        mv.visitEnd();
        cw.visitEnd();
        byte[] clazzBytesCPA = cw.toByteArray();
        Class<?> clazzCPA = ClassLoaderInjector.injectClass(Type.getObjectType((String)this.powerMockHelperClassRaw).getClassName(), clazzBytesCPA);
        try {
            clazzCPA.getField(FIELD_TEST_CLASS_BYTE_ARR).set(null, clazzBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error installing powermock helper", e);
        }
        try {
            clazzCPA.getField(FIELD_CONSTRUCTOR_ARGS).set(null, constructorArgs);
        }
        catch (Exception e) {
            throw new RuntimeException("Error installing parameterized arguments", e);
        }
    }
}

