/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.junit.runners.parameterized;

import com.nitorcreations.junit.runners.parameterized.ClassLoaderInjector;
import com.nitorcreations.junit.runners.parameterized.DefaultParameterizationStrategy;
import com.nitorcreations.junit.runners.parameterized.DescriptionMapper;
import com.nitorcreations.junit.runners.parameterized.DescriptionMappingRunNotifierProxy;
import com.nitorcreations.junit.runners.parameterized.ParameterizationStrategy;
import com.nitorcreations.junit.runners.parameterized.ParameterizationStrategyNotAvailableException;
import com.nitorcreations.junit.runners.parameterized.ParameterizedSuite;
import com.nitorcreations.junit.runners.parameterized.ParameterizedSuiteBuilder;
import com.nitorcreations.junit.runners.parameterized.PowermockParameterizationStrategy;
import com.nitorcreations.junit.runners.parameterized.WrappedRunWith;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingParameterizedRunner
extends Runner {
    private final Class<?> testClass;
    private final DescriptionMapper descriptionMapper;
    private final Constructor<? extends Runner> wrappedRunnerConstructor;
    private Description description;
    private Runner[] runners;
    private String[] testDescriptions;
    private Exception totalFailure;

    public WrappingParameterizedRunner(Class<?> testClass) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (Modifier.isFinal(testClass.getModifiers())) {
            throw new IllegalArgumentException("Cannot operate on test classes marked final: " + testClass);
        }
        this.testClass = testClass;
        this.descriptionMapper = new DescriptionMapper(testClass);
        Class<JUnit4> wrappedRunnerClass = JUnit4.class;
        WrappedRunWith wrappedRunWith = testClass.getAnnotation(WrappedRunWith.class);
        if (wrappedRunWith != null) {
            wrappedRunnerClass = wrappedRunWith.value();
        }
        this.wrappedRunnerConstructor = wrappedRunnerClass.getConstructor(Class.class);
    }

    private void ensureSetup() {
        if (this.runners != null) {
            return;
        }
        try {
            List<ParameterizedSuiteBuilder.TestInstantiatorBuilder> tests = this.fetchTests();
            this.runners = new Runner[tests.size()];
            this.testDescriptions = new String[this.runners.length];
            int i = 0;
            for (ParameterizedSuiteBuilder.TestInstantiatorBuilder test : tests) {
                String errorMsg = "Failed to get test descriptions";
                try {
                    this.testDescriptions[i] = test.getDescription();
                    errorMsg = "Failed to create test class";
                    Class<?> parameterizedTestClass = this.createParameterizedTestClass(i, test);
                    errorMsg = "Failed to create runner for test";
                    this.runners[i] = this.wrappedRunnerConstructor.newInstance(parameterizedTestClass);
                }
                catch (ParameterizationStrategyNotAvailableException e) {
                    throw e;
                }
                catch (Exception e) {
                    RuntimeException exception = new RuntimeException(errorMsg, e);
                    if (this.testDescriptions[i] == null) {
                        this.testDescriptions[i] = "Test " + i;
                    }
                    Description dummyDescription = Description.createSuiteDescription((String)("Dummy  " + (System.identityHashCode((Object)this) + i)), (Annotation[])new Annotation[0]);
                    this.runners[i] = new FailingRunner(dummyDescription, exception);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            this.totalFailure = e;
            this.runners = null;
            this.testDescriptions = null;
        }
    }

    private List<ParameterizedSuiteBuilder.TestInstantiatorBuilder> fetchTests() {
        Method foundMethod = this.getParameterizedSuiteMethod();
        ParameterizedSuiteBuilder builder = new ParameterizedSuiteBuilder(this.testClass);
        try {
            foundMethod.invoke(null, builder);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to build parameterized suite for " + this.testClass.getName(), t);
        }
        List<ParameterizedSuiteBuilder.TestInstantiatorBuilder> tests = builder.getTests();
        return tests;
    }

    private Method getParameterizedSuiteMethod() {
        Method foundMethod = null;
        for (Method method : this.testClass.getMethods()) {
            if (null == method.getAnnotation(ParameterizedSuite.class)) continue;
            if (foundMethod == null) {
                foundMethod = method;
                continue;
            }
            throw new IllegalArgumentException("Class " + this.testClass.getName() + " contains multiple methods annotated with @" + ParameterizedSuite.class.getSimpleName() + ", expected exactly one");
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException("Class " + this.testClass.getName() + " must have a static method annotated with @" + ParameterizedSuite.class.getSimpleName());
        }
        if (!Modifier.isStatic(foundMethod.getModifiers())) {
            throw new IllegalArgumentException("Class " + this.testClass.getName() + " method " + foundMethod + " must be static");
        }
        Class<?>[] parameterTypes = foundMethod.getParameterTypes();
        if (parameterTypes.length != 1 || parameterTypes[0] != ParameterizedSuiteBuilder.class) {
            throw new IllegalArgumentException("Class " + this.testClass.getName() + " method " + foundMethod + " must take exactly one argument of type " + ParameterizedSuiteBuilder.class.getSimpleName());
        }
        return foundMethod;
    }

    private Class<?> createParameterizedTestClass(int testIdx, ParameterizedSuiteBuilder.TestInstantiatorBuilder test) {
        ClassWriter cw = new ClassWriter(3);
        String testClassNameRaw = Type.getInternalName(this.testClass);
        String extendingTestClassName = this.testClass.getName() + '_' + testIdx;
        String extendingTestClassNameRaw = testClassNameRaw + '_' + testIdx;
        ParameterizationStrategy strategy = this.chooseParameterizationStrategy();
        cw.visit(49, 33, extendingTestClassNameRaw, null, testClassNameRaw, null);
        strategy.classCreationInProgress(extendingTestClassNameRaw, (ClassVisitor)cw);
        MethodVisitor mvo = cw.visitMethod(1, "<init>", "()V", null, null);
        GeneratorAdapter mv = new GeneratorAdapter(mvo, 1, "<init>", "()V");
        mv.visitCode();
        Label label = new Label();
        mv.visitLabel(label);
        mv.visitLineNumber(1, label);
        strategy.loadConstructorArgs(mv);
        mv.visitVarInsn(58, 1);
        mv.loadThis();
        Type constructorType = Type.getType(test.getConstructor());
        Type[] argumentTypes = constructorType.getArgumentTypes();
        for (int arg = 0; arg < test.getConstructorArgs().length; ++arg) {
            Type argType = argumentTypes[arg];
            mv.visitVarInsn(25, 1);
            mv.push(arg);
            mv.visitInsn(50);
            mv.unbox(argType);
        }
        String constructorArgsRaw = constructorType.getDescriptor();
        mv.visitMethodInsn(183, testClassNameRaw, "<init>", constructorArgsRaw);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] clazzBytes = cw.toByteArray();
        try {
            FileOutputStream fos = new FileOutputStream("/tmp/x.class");
            fos.write(clazzBytes);
            fos.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Class<?> clazz = ClassLoaderInjector.injectClass(extendingTestClassName, clazzBytes);
        strategy.classConstructed(clazz, clazzBytes, test.getConstructorArgs());
        return clazz;
    }

    private ParameterizationStrategy chooseParameterizationStrategy() {
        if (this.wrappedRunnerConstructor.getDeclaringClass().getPackage().getName().contains("powermock")) {
            return new PowermockParameterizationStrategy();
        }
        return new DefaultParameterizationStrategy();
    }

    public synchronized Description getDescription() {
        if (this.description == null) {
            this.ensureSetup();
            Description d = Description.createSuiteDescription(this.testClass);
            if (this.totalFailure == null) {
                for (int i = 0; i < this.runners.length; ++i) {
                    String testDescription = i + ". " + this.testDescriptions[i];
                    Runner runner = this.runners[i];
                    d.addChild(this.descriptionMapper.rewriteDescription(testDescription, runner.getDescription()));
                }
            }
            this.description = d;
        }
        return this.description;
    }

    public synchronized void run(RunNotifier notifier) {
        this.getDescription();
        if (this.totalFailure != null) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)this.totalFailure));
        } else {
            notifier = new DescriptionMappingRunNotifierProxy(notifier, this.descriptionMapper);
            for (Runner runner : this.runners) {
                runner.run(notifier);
            }
        }
    }

    private static final class FailingRunner
    extends Runner {
        private final Description description;
        private final RuntimeException exception;

        FailingRunner(Description description, RuntimeException exception) {
            this.description = description;
            this.exception = exception;
        }

        public void run(RunNotifier notifier) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)this.exception));
        }

        public Description getDescription() {
            return this.description;
        }
    }
}

