/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsCollectionContaining;

public final class CollectionMatchers {
    @Factory
    public static <E> Matcher<Iterable<? extends E>> containsElements(Collection<E> coll) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (E e : coll) {
            matchers.add(Matchers.equalTo(e));
        }
        return Matchers.contains(matchers);
    }

    @Factory
    public static <E> Matcher<Iterable<? extends E>> containsElementsInAnyOrder(Collection<E> coll) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (E e : coll) {
            matchers.add(Matchers.equalTo(e));
        }
        return Matchers.containsInAnyOrder(matchers);
    }

    @Factory
    public static <T> Matcher<Iterable<T>> hasItemsOf(Collection<T> items) {
        ArrayList<IsCollectionContaining> all = new ArrayList<IsCollectionContaining>(items.size());
        for (T element : items) {
            all.add(new IsCollectionContaining(Matchers.equalTo(element)));
        }
        return AllOf.allOf(all);
    }

    @Factory
    public static <T, S extends Collection<T>> Matcher<? super S> hasNoDuplicates(Class<T> ofClass) {
        return new TypeSafeMatcher<S>(){

            public void describeTo(Description description) {
                description.appendText("without duplicates");
            }

            public boolean matchesSafely(S item) {
                return new HashSet(item).size() == item.size();
            }
        };
    }

    @Factory
    public static <T extends List<?>> Matcher<T> emptyList() {
        return new TypeSafeDiagnosingMatcher<T>(){

            protected boolean matchesSafely(T item, Description mismatchDescription) {
                mismatchDescription.appendText("was not empty: size: ").appendValue((Object)item.size());
                return item.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("empty list");
            }
        };
    }

    private CollectionMatchers() {
    }
}

