/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class CountThat<T>
extends TypeSafeDiagnosingMatcher<Iterable<T>> {
    private final Matcher<T> itemMatcher;
    private final Matcher<Integer> size;

    private CountThat(Matcher<T> itemMatcher, Matcher<Integer> size) {
        this.itemMatcher = (Matcher)Validate.notNull(itemMatcher);
        this.size = (Matcher)Validate.notNull(size);
    }

    @Factory
    public static <T> Matcher<Iterable<T>> countThat(Matcher<T> itemMatcher, Matcher<Integer> size) {
        return new CountThat<T>(itemMatcher, size);
    }

    @Factory
    public static <T> Matcher<Iterable<T>> countThat(Matcher<T> itemMatcher, int size) {
        return CountThat.countThat(itemMatcher, (Matcher<Integer>)Matchers.equalTo((Object)size));
    }

    protected boolean matchesSafely(Iterable<T> item, Description mismatchDescription) {
        int count = 0;
        for (T t : item) {
            if (!this.itemMatcher.matches(t)) continue;
            ++count;
        }
        mismatchDescription.appendText("contained ").appendValue((Object)count).appendText(" items that ").appendDescriptionOf(this.itemMatcher);
        return this.size.matches((Object)count);
    }

    public void describeTo(Description description) {
        description.appendText("iterable containing ").appendDescriptionOf(this.size).appendText(" items that ").appendDescriptionOf(this.itemMatcher);
    }
}

