/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class FieldMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final String fieldName;
    private final Matcher<?> valueMatcher;

    public FieldMatcher(String fieldName, Matcher<?> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("has field \"").appendText(this.fieldName).appendText("\"");
        if (this.valueMatcher != null) {
            description.appendText(" with value ").appendDescriptionOf(this.valueMatcher);
        }
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        Field field = FieldMatcher.findField(item.getClass(), this.fieldName);
        if (field == null) {
            return false;
        }
        if (this.valueMatcher == null) {
            return true;
        }
        try {
            return this.valueMatcher.matches(field.get(item));
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private static Field findField(Class<?> clazz, String name) {
        Class<?> searchType = clazz;
        while (!Object.class.equals(searchType)) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)field.getName())) continue;
                return field;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    @Factory
    public static <T> FieldMatcher<T> hasField(String fieldName) {
        return new FieldMatcher<T>(fieldName, null);
    }

    @Factory
    public static <T> FieldMatcher<T> hasField(String fieldName, Matcher<?> withValue) {
        return new FieldMatcher<T>(fieldName, withValue);
    }
}

