/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class HasItemAtIndex<X>
extends TypeSafeDiagnosingMatcher<Iterable<X>> {
    private final Integer index;
    private final Matcher<X> itemMatcher;

    private HasItemAtIndex(Integer index, Matcher<X> itemMatcher) {
        this.index = index;
        this.itemMatcher = itemMatcher;
    }

    private static <T> T getItem(List<T> list, Integer index) {
        if (index == null) {
            return list.get(list.size() - 1);
        }
        return list.get(index);
    }

    private static <T> List<T> getList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    @Factory
    public static <T> Matcher<Iterable<T>> hasFirstItem(Matcher<T> item) {
        return new HasItemAtIndex<T>(0, item);
    }

    @Factory
    public static <T> Matcher<Iterable<T>> hasLastItem(Matcher<T> item) {
        return new HasItemAtIndex<T>(null, item);
    }

    @Factory
    public static <T> Matcher<Iterable<T>> hasItemAtIndex(int index, Matcher<T> item) {
        return new HasItemAtIndex<T>(index, item);
    }

    protected boolean matchesSafely(Iterable<X> iterable, Description mismatchDescription) {
        List<X> list = HasItemAtIndex.getList(iterable);
        if (list.isEmpty()) {
            mismatchDescription.appendText("iterable was empty");
            return false;
        }
        if (this.index != null && this.index >= list.size()) {
            mismatchDescription.appendText("size was ").appendValue((Object)list.size());
            return false;
        }
        X item = HasItemAtIndex.getItem(list, this.index);
        this.itemMatcher.describeMismatch(item, mismatchDescription);
        return this.itemMatcher.matches(item);
    }

    public void describeTo(Description description) {
        if (this.index == null) {
            description.appendText("iterable with last item: ");
        } else {
            description.appendText(String.format("iterable with item at index %d: ", this.index));
        }
        description.appendDescriptionOf(this.itemMatcher);
    }
}

