/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IteratorMatcher<T extends Iterator<?>>
extends TypeSafeDiagnosingMatcher<T> {
    private final Matcher<?> iterableMatcher;

    private IteratorMatcher(Matcher<?> iterableMatcher) {
        this.iterableMatcher = iterableMatcher;
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        List<Object> list = IteratorMatcher.getList(item);
        this.iterableMatcher.describeMismatch(list, mismatchDescription);
        return this.iterableMatcher.matches(list);
    }

    private static <T extends Iterator<?>> List<Object> getList(T iterator) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public void describeTo(Description description) {
        description.appendText("iterator of ").appendDescriptionOf(this.iterableMatcher);
    }

    @Factory
    public static <T extends Iterator<?>, X extends Iterable<?>> Matcher<? super T> iteratorThat(Matcher<X> iterableMatcher) {
        return new IteratorMatcher<T>(iterableMatcher);
    }
}

